/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.types;

import java.lang.ref.WeakReference;
import org.eclipse.serializer.chars.XChars;
import org.eclipse.serializer.collections.XArrays;
import org.eclipse.serializer.persistence.exceptions.PersistenceException;
import org.eclipse.serializer.persistence.types.PersistenceLocalObjectIdRegistry;
import org.eclipse.serializer.persistence.types.PersistenceObjectIdHolder;
import org.eclipse.serializer.persistence.types.PersistenceObjectIdProvider;
import org.eclipse.serializer.persistence.types.PersistenceObjectIdRequestor;
import org.eclipse.serializer.persistence.types.PersistenceObjectRegistry;
import org.eclipse.serializer.persistence.types.PersistenceSwizzlingLookup;
import org.eclipse.serializer.persistence.types.PersistenceTypeHandler;
import org.eclipse.serializer.reference.Swizzling;
import org.eclipse.serializer.util.Cloneable;
import org.eclipse.serializer.util.X;

public interface PersistenceObjectManager<D>
extends PersistenceSwizzlingLookup,
PersistenceObjectIdHolder,
Cloneable<PersistenceObjectManager<D>> {
    public long ensureObjectId(Object var1);

    public <T> long ensureObjectId(T var1, PersistenceObjectIdRequestor<D> var2, PersistenceTypeHandler<D, T> var3);

    public <T> long ensureObjectIdGuaranteedRegister(T var1, PersistenceObjectIdRequestor<D> var2, PersistenceTypeHandler<D, T> var3);

    public void consolidate();

    @Override
    public long currentObjectId();

    @Override
    public PersistenceObjectManager<D> updateCurrentObjectId(long var1);

    default public PersistenceObjectManager<D> Clone() {
        return (PersistenceObjectManager)super.Clone();
    }

    public boolean registerLocalRegistry(PersistenceLocalObjectIdRegistry<D> var1);

    public void mergeEntries(PersistenceLocalObjectIdRegistry<D> var1);

    public static <D> Default<D> New(PersistenceObjectRegistry objectRegistry, PersistenceObjectIdProvider oidProvider) {
        return new Default((PersistenceObjectRegistry)X.notNull((Object)objectRegistry), (PersistenceObjectIdProvider)X.notNull((Object)oidProvider));
    }

    public static final class Default<D>
    implements PersistenceObjectManager<D> {
        private final PersistenceObjectRegistry objectRegistry;
        private final PersistenceObjectIdProvider oidProvider;
        private WeakReference<PersistenceLocalObjectIdRegistry<D>>[] localRegistries = X.WeakReferences((int)1);
        private final PersistenceObjectIdRequestor<D> noOp = PersistenceObjectIdRequestor.NoOp();

        Default(PersistenceObjectRegistry objectRegistry, PersistenceObjectIdProvider oidProvider) {
            this.objectRegistry = objectRegistry;
            this.oidProvider = oidProvider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Default<D> Clone() {
            PersistenceObjectRegistry persistenceObjectRegistry = this.objectRegistry;
            synchronized (persistenceObjectRegistry) {
                return new Default<D>(this.objectRegistry.Clone(), this.oidProvider.Clone());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void consolidate() {
            PersistenceObjectRegistry persistenceObjectRegistry = this.objectRegistry;
            synchronized (persistenceObjectRegistry) {
                this.objectRegistry.consolidate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long lookupObjectId(Object object) {
            PersistenceObjectRegistry persistenceObjectRegistry = this.objectRegistry;
            synchronized (persistenceObjectRegistry) {
                return this.objectRegistry.lookupObjectId(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object lookupObject(long objectId) {
            PersistenceObjectRegistry persistenceObjectRegistry = this.objectRegistry;
            synchronized (persistenceObjectRegistry) {
                return this.objectRegistry.lookupObject(objectId);
            }
        }

        @Override
        public final long ensureObjectId(Object object) {
            return this.ensureObjectId(object, this.noOp, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> long ensureObjectId(T object, PersistenceObjectIdRequestor<D> objectIdRequestor, PersistenceTypeHandler<D, T> optionalHandler) {
            PersistenceObjectRegistry persistenceObjectRegistry = this.objectRegistry;
            synchronized (persistenceObjectRegistry) {
                long objectId = this.objectRegistry.lookupObjectId(object);
                if (Swizzling.isNotProperId((long)objectId)) {
                    objectId = this.synchCheckLocalRegistries(objectIdRequestor, object, optionalHandler);
                    if (Swizzling.isNotProperId((long)objectId)) {
                        objectId = this.oidProvider.provideNextObjectId();
                    }
                    objectIdRequestor.registerLazyOptional(objectId, object, optionalHandler);
                }
                objectIdRequestor.registerEagerOptional(objectId, object, optionalHandler);
                return objectId;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> long ensureObjectIdGuaranteedRegister(T object, PersistenceObjectIdRequestor<D> objectIdRequestor, PersistenceTypeHandler<D, T> optionalHandler) {
            PersistenceObjectRegistry persistenceObjectRegistry = this.objectRegistry;
            synchronized (persistenceObjectRegistry) {
                long objectId = this.objectRegistry.lookupObjectId(object);
                if (Swizzling.isNotProperId((long)objectId) && Swizzling.isNotProperId((long)(objectId = this.synchCheckLocalRegistries(objectIdRequestor, object, optionalHandler)))) {
                    objectId = this.oidProvider.provideNextObjectId();
                }
                objectIdRequestor.registerGuaranteed(objectId, object, optionalHandler);
                return objectId;
            }
        }

        private <T> long synchCheckLocalRegistries(PersistenceObjectIdRequestor<D> objectIdRequestor, T instance, PersistenceTypeHandler<D, T> optionalHandler) {
            for (WeakReference<PersistenceLocalObjectIdRegistry<D>> localRegistryEntry : this.localRegistries) {
                long objectId;
                PersistenceLocalObjectIdRegistry localRegistry;
                if (localRegistryEntry == null || (localRegistry = (PersistenceLocalObjectIdRegistry)localRegistryEntry.get()) == null || localRegistry == objectIdRequestor || !Swizzling.isProperId((long)(objectId = localRegistry.lookupObjectId(instance, objectIdRequestor, optionalHandler)))) continue;
                return objectId;
            }
            return Swizzling.notFoundId();
        }

        private void synchInternalMergeEntries(PersistenceLocalObjectIdRegistry<D> localRegistry) {
            localRegistry.iterateMergeableEntries(this.objectRegistry::validate);
            localRegistry.iterateMergeableEntries(this.objectRegistry::registerObject);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean registerLocalRegistry(PersistenceLocalObjectIdRegistry<D> localRegistry) {
            if (localRegistry.parentObjectManager() != this) {
                throw new PersistenceException(PersistenceLocalObjectIdRegistry.class.getSimpleName() + " " + XChars.systemString(localRegistry) + " does not belong to this " + PersistenceObjectManager.class.getSimpleName() + " " + XChars.systemString((Object)this));
            }
            PersistenceObjectRegistry persistenceObjectRegistry = this.objectRegistry;
            synchronized (persistenceObjectRegistry) {
                Object[] localRegistries = this.localRegistries;
                if (Default.isAlreadyRegistered(localRegistry, localRegistries)) {
                    return false;
                }
                for (int i = 0; i < localRegistries.length; ++i) {
                    if (localRegistries[i] != null && localRegistries[i].get() != null) continue;
                    localRegistries[i] = X.WeakReference(localRegistry);
                    return true;
                }
                this.localRegistries = (WeakReference[])XArrays.enlarge((Object[])localRegistries, (int)(localRegistries.length + 1));
                this.localRegistries[localRegistries.length] = X.WeakReference(localRegistry);
                return true;
            }
        }

        private static <D> boolean isAlreadyRegistered(PersistenceLocalObjectIdRegistry<D> localRegistry, WeakReference<PersistenceLocalObjectIdRegistry<D>>[] localRegistries) {
            for (int i = 0; i < localRegistries.length; ++i) {
                if (localRegistries[i] == null) continue;
                PersistenceLocalObjectIdRegistry registeredLocalRegistry = (PersistenceLocalObjectIdRegistry)localRegistries[i].get();
                if (registeredLocalRegistry == null) {
                    localRegistries[i] = null;
                    continue;
                }
                if (registeredLocalRegistry != localRegistry) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mergeEntries(PersistenceLocalObjectIdRegistry<D> localRegistry) {
            PersistenceObjectRegistry persistenceObjectRegistry = this.objectRegistry;
            synchronized (persistenceObjectRegistry) {
                int emptySlotCount = 0;
                for (int i = 0; i < this.localRegistries.length; ++i) {
                    if (this.localRegistries[i] == null) {
                        ++emptySlotCount;
                        continue;
                    }
                    PersistenceLocalObjectIdRegistry registeredLocalRegistry = (PersistenceLocalObjectIdRegistry)this.localRegistries[i].get();
                    if (registeredLocalRegistry == null) {
                        this.localRegistries[i] = null;
                        ++emptySlotCount;
                        continue;
                    }
                    if (registeredLocalRegistry != localRegistry) continue;
                    this.synchInternalMergeEntries(localRegistry);
                    if (emptySlotCount > 2) {
                        this.localRegistries = X.consolidateWeakReferences((WeakReference[])this.localRegistries);
                    }
                    this.objectRegistry.cleanUp();
                    return;
                }
            }
            throw new PersistenceException(PersistenceLocalObjectIdRegistry.class.getSimpleName() + " " + XChars.systemString(localRegistry) + " not registered at this " + PersistenceObjectManager.class.getSimpleName() + " " + XChars.systemString((Object)this));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final long currentObjectId() {
            PersistenceObjectRegistry persistenceObjectRegistry = this.objectRegistry;
            synchronized (persistenceObjectRegistry) {
                return this.oidProvider.currentObjectId();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PersistenceObjectManager<D> updateCurrentObjectId(long currentObjectId) {
            PersistenceObjectRegistry persistenceObjectRegistry = this.objectRegistry;
            synchronized (persistenceObjectRegistry) {
                if (this.oidProvider.currentObjectId() >= currentObjectId) {
                    return this;
                }
                this.oidProvider.updateCurrentObjectId(currentObjectId);
            }
            return this;
        }
    }
}

