/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.types;

import org.eclipse.serializer.chars.Levenshtein;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMember;
import org.eclipse.serializer.typing.TypeMappingLookup;
import org.eclipse.serializer.util.X;
import org.eclipse.serializer.util.similarity.Similator;

public interface PersistenceMemberSimilator
extends Similator<PersistenceTypeDefinitionMember> {
    public static PersistenceMemberSimilator New(TypeMappingLookup<Float> typeSimilarity) {
        return new Default((TypeMappingLookup<Float>)((TypeMappingLookup)X.notNull(typeSimilarity)));
    }

    public static final class Default
    implements PersistenceMemberSimilator {
        final TypeMappingLookup<Float> typeSimilarity;

        Default(TypeMappingLookup<Float> typeSimilarity) {
            this.typeSimilarity = typeSimilarity;
        }

        public final double evaluate(PersistenceTypeDefinitionMember sourceMember, PersistenceTypeDefinitionMember targetMember) {
            if (sourceMember.isEnumConstant() != targetMember.isEnumConstant()) {
                return 0.0;
            }
            float nameSimilarity = this.calculateSimilarityByName(sourceMember, targetMember);
            float typeSimilarity = this.calculateSimilaritybyType(sourceMember, targetMember);
            return (nameSimilarity + typeSimilarity) / 2.0f;
        }

        private float calculateSimilarityByName(PersistenceTypeDefinitionMember sourceMember, PersistenceTypeDefinitionMember targetMember) {
            float nameSimilarity = Levenshtein.similarity((String)sourceMember.name(), (String)targetMember.name());
            float qualifierFactor = this.calculateQualifierSimilarityFactor(sourceMember.runtimeQualifier(), targetMember.runtimeQualifier());
            return qualifierFactor * nameSimilarity;
        }

        private float calculateQualifierSimilarityFactor(String sourceQualifier, String targetQualifier) {
            return sourceQualifier == null ? (targetQualifier == null ? 1.0f : 0.5f) : (sourceQualifier.equals(targetQualifier) ? 1.0f : 0.5f);
        }

        private float calculateSimilaritybyType(PersistenceTypeDefinitionMember sourceMember, PersistenceTypeDefinitionMember targetMember) {
            Class<?> sourceType = sourceMember.type();
            Class<?> targetType = targetMember.type();
            if (sourceType != null && targetType != null) {
                return this.calculateTypeSimilarity(sourceType, targetType);
            }
            return sourceMember.typeName().equals(targetMember.typeName()) ? 1.0f : 0.5f;
        }

        private float calculateTypeSimilarity(Class<?> type1, Class<?> type2) {
            if (type1 == type2) {
                return 1.0f;
            }
            Float mappedSimilarity = (Float)this.typeSimilarity.lookup(type1, type2);
            if (mappedSimilarity != null) {
                return mappedSimilarity.floatValue();
            }
            return 0.0f;
        }
    }
}

