/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.types;

import org.eclipse.serializer.chars.XChars;
import org.eclipse.serializer.collections.EqHashTable;
import org.eclipse.serializer.collections.HashEnum;
import org.eclipse.serializer.persistence.types.PersistenceStorer;
import org.eclipse.serializer.util.logging.Logging;
import org.slf4j.Logger;

public interface PersistenceLiveStorerRegistry
extends PersistenceStorer.CreationObserver {
    @Override
    default public void observeCreatedStorer(PersistenceStorer storer) {
        this.registerStorer(storer);
    }

    public void registerStorer(PersistenceStorer var1);

    public boolean clearGroupAndAdvance(long var1, long var3);

    public static PersistenceLiveStorerRegistry New() {
        return new Default();
    }

    public static final class Default
    implements PersistenceLiveStorerRegistry {
        private static final Logger logger = Logging.getLogger(PersistenceLiveStorerRegistry.class);
        private final EqHashTable<Long, HashEnum<PersistenceStorer>> storerGroups = EqHashTable.New();
        private long currentGroupId;

        Default() {
        }

        @Override
        public synchronized void registerStorer(PersistenceStorer storer) {
            HashEnum storerGroup = (HashEnum)this.storerGroups.get((Object)this.currentGroupId);
            if (storerGroup == null) {
                storerGroup = HashEnum.New();
                this.storerGroups.add((Object)this.currentGroupId, (Object)storerGroup);
            }
            logger.debug("Registering storer " + XChars.systemString((Object)storer) + " to id Group " + this.currentGroupId);
            storerGroup.add((Object)storer);
        }

        @Override
        public synchronized boolean clearGroupAndAdvance(long oldGroupId, long newGroupId) {
            long removeCount = this.storerGroups.removeBy(e -> (Long)e.key() <= oldGroupId);
            logger.debug(Thread.currentThread() + " removed " + removeCount + " idGroups with id <= " + oldGroupId + ".");
            this.currentGroupId = newGroupId;
            return removeCount > 0L;
        }
    }
}

