/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.types;

import org.eclipse.serializer.collections.CapacityExceededException;
import org.eclipse.serializer.collections.interfaces.Sized;
import org.eclipse.serializer.collections.interfaces._longCollector;
import org.eclipse.serializer.functional._longIterable;
import org.eclipse.serializer.functional._longProcedure;

public interface PersistenceIdSet
extends _longIterable,
Sized {
    public long size();

    public void iterate(_longProcedure var1);

    public static final class Default
    implements PersistenceIdSet,
    _longCollector {
        private static final int DEFAULT_CAPACITY = 64;
        private long[] data = new long[64];
        private int size;

        public void accept(long id) {
            if (this.size >= this.data.length) {
                if (this.size >= Integer.MAX_VALUE) {
                    throw new CapacityExceededException();
                }
                this.data = new long[(int)((float)this.data.length * 2.0f)];
                System.arraycopy(this.data, 0, this.data, 0, this.size);
            }
            this.data[this.size++] = id;
        }

        @Override
        public void iterate(_longProcedure procedure) {
            long[] data = this.data;
            int size = this.size;
            for (int i = 0; i < size; ++i) {
                procedure.accept(data[i]);
            }
        }

        @Override
        public long size() {
            return this.size;
        }

        public boolean isEmpty() {
            return this.size == 0;
        }
    }
}

