/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.types;

import org.eclipse.serializer.chars.VarString;
import org.eclipse.serializer.collections.types.XGettingEnum;
import org.eclipse.serializer.collections.types.XGettingMap;
import org.eclipse.serializer.collections.types.XGettingSet;
import org.eclipse.serializer.collections.types.XGettingTable;
import org.eclipse.serializer.persistence.exceptions.PersistenceException;
import org.eclipse.serializer.persistence.types.PersistenceLegacyTypeMapper;
import org.eclipse.serializer.persistence.types.PersistenceLegacyTypeMappingResult;
import org.eclipse.serializer.persistence.types.PersistenceLegacyTypeMappingResultor;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinition;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinitionMember;
import org.eclipse.serializer.persistence.types.PersistenceTypeHandler;
import org.eclipse.serializer.util.X;
import org.eclipse.serializer.util.logging.Logging;
import org.eclipse.serializer.util.similarity.MultiMatch;
import org.eclipse.serializer.util.similarity.Similarity;
import org.slf4j.Logger;

public class LoggingLegacyTypeMappingResultor<D>
implements PersistenceLegacyTypeMappingResultor<D> {
    private static final Logger logger = Logging.getLogger(LoggingLegacyTypeMappingResultor.class);
    final PersistenceLegacyTypeMappingResultor<D> delegate;

    public static String assembleMappingWithHeader(XGettingMap<PersistenceTypeDefinitionMember, PersistenceTypeDefinitionMember> explicitMappings, MultiMatch<PersistenceTypeDefinitionMember> matchedMembers, PersistenceLegacyTypeMappingResult<?, ?> result) {
        VarString vs = VarString.New();
        LoggingLegacyTypeMappingResultor.assembleMappingHeader(vs, result);
        LoggingLegacyTypeMappingResultor.assembleMapping(vs, explicitMappings, matchedMembers, result);
        return vs.toString();
    }

    public static VarString assembleMappingHeader(VarString vs, PersistenceLegacyTypeMappingResult<?, ?> result) {
        vs.add("Legacy type mapping required for legacy type ").lf().add(result.legacyTypeDefinition().toTypeIdentifier()).lf().add("to current type ").lf().add(result.currentTypeHandler().toTypeIdentifier()).lf().add("Fields:").lf();
        return vs;
    }

    public static VarString assembleMapping(VarString vs, XGettingMap<PersistenceTypeDefinitionMember, PersistenceTypeDefinitionMember> explicitMappings, MultiMatch<PersistenceTypeDefinitionMember> matchedMembers, PersistenceLegacyTypeMappingResult<?, ?> result) {
        XGettingTable<PersistenceTypeDefinitionMember, Similarity<PersistenceTypeDefinitionMember>> currentToLegacyMembers = result.currentToLegacyMembers();
        XGettingEnum<PersistenceTypeDefinitionMember> newCurrentMembers = result.newCurrentMembers();
        for (PersistenceTypeDefinitionMember currentMember : result.currentTypeHandler().membersInDeclaredOrder()) {
            Similarity legacyMember = (Similarity)currentToLegacyMembers.get((Object)currentMember);
            if (legacyMember != null) {
                LoggingLegacyTypeMappingResultor.assembleMemberName(vs, (PersistenceTypeDefinitionMember)legacyMember.sourceElement()).blank();
                LoggingLegacyTypeMappingResultor.assembleTokenMappedMember(vs, (Similarity<PersistenceTypeDefinitionMember>)legacyMember).blank();
                LoggingLegacyTypeMappingResultor.assembleMemberName(vs, currentMember).lf();
                continue;
            }
            if (newCurrentMembers.contains((Object)currentMember)) {
                vs.blank();
                LoggingLegacyTypeMappingResultor.assembleTokenNewMember(vs).blank();
                LoggingLegacyTypeMappingResultor.assembleMemberName(vs, currentMember).lf();
                continue;
            }
            throw new PersistenceException("Inconsistent current type member mapping: " + currentMember.identifier());
        }
        for (PersistenceTypeDefinitionMember e : result.discardedLegacyMembers()) {
            LoggingLegacyTypeMappingResultor.assembleMemberName(vs, e).blank();
            LoggingLegacyTypeMappingResultor.assembleTokenDiscardedMember(vs);
            vs.lf();
        }
        return vs;
    }

    static final VarString assembleTokenMappedMember(VarString vs, Similarity<PersistenceTypeDefinitionMember> mappedLegacyMember) {
        return vs.add('-').padRight(PersistenceLegacyTypeMapper.similarityToString(mappedLegacyMember), PersistenceLegacyTypeMapper.Defaults.defaultMappingTokenBaseLength(), '-').add("->");
    }

    static final VarString assembleTokenNewMember(VarString vs) {
        return vs.add(PersistenceLegacyTypeMapper.Defaults.defaultNewMemberString());
    }

    static final VarString assembleTokenDiscardedMember(VarString vs) {
        return vs.add(PersistenceLegacyTypeMapper.Defaults.defaultDiscardedMemberString());
    }

    public static final VarString assembleMemberName(VarString vs, PersistenceTypeDefinitionMember member) {
        return vs.add(member.typeName()).blank().add(member.identifier());
    }

    public static <D> LoggingLegacyTypeMappingResultor<D> New(PersistenceLegacyTypeMappingResultor<D> delegate) {
        return new LoggingLegacyTypeMappingResultor<D>((PersistenceLegacyTypeMappingResultor)X.notNull(delegate));
    }

    LoggingLegacyTypeMappingResultor(PersistenceLegacyTypeMappingResultor<D> delegate) {
        this.delegate = delegate;
    }

    @Override
    public <T> PersistenceLegacyTypeMappingResult<D, T> createMappingResult(PersistenceTypeDefinition legacyTypeDefinition, PersistenceTypeHandler<D, T> currentTypeHandler, XGettingMap<PersistenceTypeDefinitionMember, PersistenceTypeDefinitionMember> explicitMappings, XGettingSet<PersistenceTypeDefinitionMember> explicitNewMembers, MultiMatch<PersistenceTypeDefinitionMember> matchedMembers) {
        PersistenceLegacyTypeMappingResult<D, T> result = this.delegate.createMappingResult(legacyTypeDefinition, currentTypeHandler, explicitMappings, explicitNewMembers, matchedMembers);
        String output = LoggingLegacyTypeMappingResultor.assembleMappingWithHeader(explicitMappings, matchedMembers, result);
        logger.info(output.trim());
        return result;
    }
}

