/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.designgridlayout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JComponent;
import javax.swing.JLabel;
import net.java.dev.designgridlayout.AbstractRow;
import net.java.dev.designgridlayout.CenterRow;
import net.java.dev.designgridlayout.ComponentGapsHelper;
import net.java.dev.designgridlayout.DefaultGrowPolicy;
import net.java.dev.designgridlayout.GridRow;
import net.java.dev.designgridlayout.HeightGrowPolicy;
import net.java.dev.designgridlayout.IExtractor;
import net.java.dev.designgridlayout.IGridRow;
import net.java.dev.designgridlayout.INonGridRow;
import net.java.dev.designgridlayout.IRowCreator;
import net.java.dev.designgridlayout.IRowItem;
import net.java.dev.designgridlayout.ISpannableGridRow;
import net.java.dev.designgridlayout.LayoutHelper;
import net.java.dev.designgridlayout.LeftRow;
import net.java.dev.designgridlayout.MinWidthExtractor;
import net.java.dev.designgridlayout.OrientationPolicy;
import net.java.dev.designgridlayout.PrefWidthExtractor;
import net.java.dev.designgridlayout.RightRow;
import net.java.dev.designgridlayout.UnitHeightGrowPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DesignGridLayout
implements LayoutManager {
    private static HeightGrowPolicy _defaultHeightTester = new DefaultGrowPolicy();
    private HeightGrowPolicy _heightTester = _defaultHeightTester;
    private final Container _parent;
    private final OrientationPolicy _orientation;
    private Dimension _preferredSize = null;
    private Dimension _minimumSize = null;
    private int _top;
    private int _left;
    private int _bottom;
    private int _right;
    private int _hgap;
    private int _gridgap;
    private double _totalWeight;
    private double _topWeight = 1.0;
    private double _leftWeight = 1.0;
    private double _bottomWeight = 1.0;
    private double _rightWeight = 1.0;
    private AbstractRow _current = null;
    private final List<AbstractRow> _rows = new ArrayList<AbstractRow>();
    private final List<Integer> _labelWidths = new ArrayList<Integer>();
    private int _totalLabelWidth;
    private int _maxGrids;

    public DesignGridLayout(Container parent) {
        if (parent == null) {
            throw new NullPointerException("parent cannot be null");
        }
        this._parent = parent;
        this._parent.setLayout(this);
        this._orientation = new OrientationPolicy(parent);
    }

    public DesignGridLayout margins(double top, double left, double bottom, double right) {
        this._topWeight = top < 0.0 ? 0.0 : top;
        this._leftWeight = left < 0.0 ? 0.0 : left;
        this._bottomWeight = bottom < 0.0 ? 0.0 : bottom;
        this._rightWeight = right < 0.0 ? 0.0 : right;
        return this;
    }

    public DesignGridLayout margins(double ratio) {
        return this.margins(ratio, ratio, ratio, ratio);
    }

    public DesignGridLayout disableSmartVerticalResize() {
        if (!(this._heightTester instanceof UnitHeightGrowPolicy)) {
            this._heightTester = new UnitHeightGrowPolicy(this._heightTester);
        }
        return this;
    }

    public IRowCreator row() {
        return new RowCreator(-1.0);
    }

    public IRowCreator row(double verticalWeight) {
        return new RowCreator(verticalWeight);
    }

    public void emptyRow() {
        if (this._current != null) {
            this._current.setUnrelatedGap();
        }
    }

    private <T extends AbstractRow> T addRow(T row, double verticalWeight) {
        this._current = row;
        this._rows.add(row);
        row.init(this._parent, this._heightTester, this._orientation);
        row.growWeight(verticalWeight);
        return row;
    }

    @Override
    public void addLayoutComponent(String constraint, Component component) {
        throw new IllegalArgumentException("Do not use this method");
    }

    @Override
    public void removeLayoutComponent(Component parent) {
        throw new IllegalArgumentException("Do not use this method");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        this.checkParent(parent);
        if (this._rows.isEmpty()) {
            return;
        }
        Object object = parent.getTreeLock();
        synchronized (object) {
            int rowWidth;
            this.initialize();
            double totalExtraHeight = 0.0;
            if (this._totalWeight > 0.0) {
                totalExtraHeight = Math.max(0.0, (double)(parent.getHeight() - this._preferredSize.height) / this._totalWeight);
            }
            boolean rtl = this._orientation.isRightToLeft();
            int x = this.left();
            int y = this.top();
            int parentWidth = parent.getWidth();
            parentWidth = Math.max(parentWidth, this._minimumSize.width);
            int gridsWidth = rowWidth = parentWidth - this.left() - this.right();
            if (this._totalLabelWidth > 0) {
                gridsWidth -= this._totalLabelWidth + this._maxGrids * this._hgap;
            }
            gridsWidth -= (this._maxGrids - 1) * this._gridgap;
            LayoutHelper helper = new LayoutHelper(this._heightTester, parentWidth, rtl, this._rows);
            for (AbstractRow row : this._rows) {
                if (row.isEmpty()) continue;
                helper.setY(y);
                int extraHeight = (int)(row.growWeight() * totalExtraHeight);
                helper.setRowAvailableHeight(extraHeight + row.height());
                row.layoutRow(helper, x, this._hgap, this._gridgap, rowWidth, gridsWidth, this._labelWidths);
                row.actualHeight(row.height() + extraHeight);
                y += row.actualHeight() + row.vgap();
            }
            int rowIndex = 0;
            for (AbstractRow row : this._rows) {
                for (IRowItem iRowItem : row.items()) {
                    if (!iRowItem.isFirstSpanRow() || iRowItem.isLastSpanRow()) continue;
                    helper.setHeight(rowIndex, iRowItem.component(), iRowItem.rowSpan());
                }
                ++rowIndex;
            }
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        this.checkParent(parent);
        this.reset();
        this.initialize();
        return new Dimension(this._minimumSize);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        this.checkParent(parent);
        this.reset();
        this.initialize();
        return new Dimension(this._preferredSize);
    }

    private void checkParent(Container parent) {
        if (parent != this._parent) {
            throw new IllegalArgumentException("must use DesignGridLayout instance with original parent container");
        }
    }

    private int top() {
        return this._parent.getInsets().top + (int)(this._topWeight * (double)this._top);
    }

    private int left() {
        return this._parent.getInsets().left + (int)(this._leftWeight * (double)this._left);
    }

    private int bottom() {
        return this._parent.getInsets().bottom + (int)(this._bottomWeight * (double)this._bottom);
    }

    private int right() {
        return this._parent.getInsets().right + (int)(this._rightWeight * (double)this._right);
    }

    private void computeGutters() {
        this._hgap = 0;
        this._gridgap = 0;
        for (AbstractRow row : this._rows) {
            this._hgap = Math.max(this._hgap, row.hgap());
            this._gridgap = Math.max(this._gridgap, row.gridgap());
        }
        ComponentGapsHelper helper = ComponentGapsHelper.instance();
        int nthRow = 0;
        for (AbstractRow row : this._rows) {
            ++nthRow;
            if (row.isEmpty()) continue;
            AbstractRow next = this.nextNonEmptyRow(nthRow);
            if (next == null) break;
            int maxComboHeight = 0;
            int rowGap = 0;
            List<? extends IRowItem> items1 = row.allItems();
            List<? extends IRowItem> items2 = next.allItems();
            int style = row.hasUnrelatedGap() ? 1 : 0;
            for (IRowItem iRowItem : items1) {
                if (!iRowItem.isLastSpanRow()) continue;
                JComponent upper = iRowItem.component();
                int aboveHeight = upper.getPreferredSize().height;
                for (IRowItem iRowItem2 : items2) {
                    if (!iRowItem2.isFirstSpanRow()) continue;
                    JComponent lower = iRowItem2.component();
                    int belowHeight = lower.getPreferredSize().height;
                    int gap = helper.getVerticalGap(upper, lower, style, this._parent);
                    int comboHeight = aboveHeight + gap + belowHeight;
                    if (comboHeight <= maxComboHeight) continue;
                    maxComboHeight = comboHeight;
                    rowGap = gap;
                }
            }
            row.vgap(rowGap);
        }
    }

    private void initialize() {
        if (this._preferredSize != null) {
            return;
        }
        if (this._rows.isEmpty()) {
            this._preferredSize = new Dimension(0, 0);
            this._minimumSize = new Dimension(0, 0);
            return;
        }
        this.countGrids();
        for (AbstractRow row : this._rows) {
            row.checkSpanRows();
        }
        this.computeMargins();
        this.computeGutters();
        this.initRowSpanItems();
        for (AbstractRow row : this._rows) {
            row.init();
        }
        this.computeLabelWidths();
        int preferredWidth = this.computeGridWidth(PrefWidthExtractor.INSTANCE);
        int minimumWidth = this.computeGridWidth(MinWidthExtractor.INSTANCE);
        int preferredHeight = this.totalHeight() + this.top() + this.bottom() + 1;
        this._totalWeight = 0.0;
        for (AbstractRow row : this._rows) {
            this._totalWeight += row.growWeight();
        }
        this._preferredSize = new Dimension(preferredWidth, preferredHeight);
        this._minimumSize = new Dimension(minimumWidth, preferredHeight);
    }

    private void initRowSpanItems() {
        int rowIndex = 0;
        for (AbstractRow row : this._rows) {
            for (IRowItem iRowItem : row.items()) {
                if (!iRowItem.isFirstSpanRow()) continue;
                List<AbstractRow> spannedRows = this._rows.subList(rowIndex, rowIndex + iRowItem.rowSpan());
                iRowItem.setSpannedRows(spannedRows);
            }
            ++rowIndex;
        }
    }

    private void countGrids() {
        this._maxGrids = 0;
        for (AbstractRow row : this._rows) {
            this._maxGrids = Math.max(this._maxGrids, row.numGrids());
        }
        for (AbstractRow row : this._rows) {
            row.totalGrids(this._maxGrids);
        }
    }

    private int countGridColumns(int grid) {
        int maxColumns = 0;
        for (AbstractRow row : this._rows) {
            maxColumns = Math.max(maxColumns, row.gridColumns(grid));
        }
        return maxColumns;
    }

    private void computeLabelWidths() {
        this._labelWidths.clear();
        this._totalLabelWidth = 0;
        for (int i = 0; i < this._maxGrids; ++i) {
            int width = 0;
            for (AbstractRow row : this._rows) {
                width = Math.max(width, row.labelWidth(i));
            }
            this._labelWidths.add(width);
            this._totalLabelWidth += width;
        }
    }

    private int totalHeight() {
        int totalHeight = 0;
        for (AbstractRow row : this._rows) {
            totalHeight += row.height() + row.vgap();
        }
        return totalHeight;
    }

    private int computeGridWidth(IExtractor extractor) {
        int width = 0;
        for (int grid = 0; grid < this._maxGrids; ++grid) {
            int maxColumns = this.countGridColumns(grid);
            int maxWidth = this.maxGridRowsColumnWidth(grid, maxColumns, extractor);
            int gridWidth = maxWidth * maxColumns + this._hgap * (maxColumns - 1) + 1;
            width = Math.max(width, gridWidth);
        }
        width *= this._maxGrids;
        if (this._totalLabelWidth > 0) {
            width += this._totalLabelWidth + this._maxGrids * this._hgap;
        }
        width += (this._maxGrids - 1) * this._gridgap;
        width += this.left() + this.right();
        width = Math.max(width, this.totalNonGridWidth(extractor));
        return width;
    }

    private int maxGridRowsColumnWidth(int grid, int maxColumns, IExtractor extractor) {
        int maxWidth = 0;
        for (AbstractRow row : this._rows) {
            int width = row.maxColumnWidth(grid, maxColumns, extractor);
            int span = row.gridspan(grid);
            if (span > 1) {
                for (int i = 1; i < span; ++i) {
                    width -= this._gridgap + this._labelWidths.get(grid + i) + this._hgap;
                }
                int fudge = width % span;
                width /= span;
                if (fudge > 0) {
                    ++width;
                }
            }
            maxWidth = Math.max(maxWidth, width);
        }
        return maxWidth;
    }

    private int totalNonGridWidth(IExtractor extractor) {
        int maxWidth = 0;
        for (AbstractRow row : this._rows) {
            maxWidth = Math.max(maxWidth, row.totalNonGridWidth(this._hgap, extractor));
        }
        return maxWidth + this.left() + this.right() + 1;
    }

    private void computeMargins() {
        this.computeTopMargin();
        this.computeBottomMargin();
        this.computeLeftRightMargins();
    }

    private void computeTopMargin() {
        this._top = 0;
        AbstractRow topRow = this.firstNonEmptyRow();
        if (topRow != null) {
            ComponentGapsHelper helper = ComponentGapsHelper.instance();
            for (IRowItem iRowItem : topRow.allItems()) {
                int gap = helper.getNorthContainerGap(iRowItem.component(), this._parent);
                this._top = Math.max(this._top, gap);
            }
        }
    }

    private void computeBottomMargin() {
        this._bottom = 0;
        int maxComboHeight = 0;
        int bottomGap = 0;
        AbstractRow bottomRow = this.lastNonEmptyRow();
        if (bottomRow != null) {
            ComponentGapsHelper helper = ComponentGapsHelper.instance();
            for (IRowItem iRowItem : bottomRow.allItems()) {
                int gap;
                int height = iRowItem.preferredHeight();
                int comboHeight = height + (gap = helper.getSouthContainerGap(iRowItem.component(), this._parent));
                if (comboHeight <= maxComboHeight) continue;
                maxComboHeight = comboHeight;
                bottomGap = gap;
            }
            this._bottom = Math.max(this._bottom, bottomGap);
        }
    }

    private AbstractRow firstNonEmptyRow() {
        for (AbstractRow row : this._rows) {
            if (row.isEmpty()) continue;
            return row;
        }
        return null;
    }

    private AbstractRow nextNonEmptyRow(int index) {
        for (int i = index; i < this._rows.size(); ++i) {
            AbstractRow row = this._rows.get(i);
            if (row.isEmpty()) continue;
            return row;
        }
        return null;
    }

    private AbstractRow lastNonEmptyRow() {
        ListIterator<AbstractRow> i = this._rows.listIterator(this._rows.size());
        while (i.hasPrevious()) {
            AbstractRow row = i.previous();
            if (row.isEmpty()) continue;
            return row;
        }
        return null;
    }

    private void computeLeftRightMargins() {
        this._left = 0;
        this._right = 0;
        ComponentGapsHelper helper = ComponentGapsHelper.instance();
        for (AbstractRow row : this._rows) {
            JComponent right;
            JComponent left = row.leftComponent();
            if (left != null) {
                this._left = Math.max(this._left, helper.getWestContainerGap(left, this._parent));
            }
            if ((right = row.rightComponent()) == null) continue;
            this._right = Math.max(this._right, helper.getEastContainerGap(right, this._parent));
        }
    }

    private void reset() {
        this._preferredSize = null;
    }

    private class RowCreator
    implements IRowCreator {
        private final double _weight;

        RowCreator(double weight) {
            this._weight = weight;
        }

        public INonGridRow center() {
            return (INonGridRow)((Object)DesignGridLayout.this.addRow(new CenterRow(), this._weight));
        }

        public INonGridRow left() {
            return (INonGridRow)((Object)DesignGridLayout.this.addRow(new LeftRow(), this._weight));
        }

        public INonGridRow right() {
            return (INonGridRow)((Object)DesignGridLayout.this.addRow(new RightRow(), this._weight));
        }

        public ISpannableGridRow grid(JLabel label) {
            return ((GridRow)DesignGridLayout.this.addRow(this.newGridRow(), this._weight)).grid(label);
        }

        public IGridRow grid(JLabel label, int gridspan) {
            return ((GridRow)DesignGridLayout.this.addRow(this.newGridRow(), this._weight)).grid(label, gridspan);
        }

        public ISpannableGridRow grid() {
            return ((GridRow)DesignGridLayout.this.addRow(this.newGridRow(), this._weight)).grid();
        }

        public IGridRow grid(int gridspan) {
            return ((GridRow)DesignGridLayout.this.addRow(this.newGridRow(), this._weight)).grid(gridspan);
        }

        private GridRow newGridRow() {
            AbstractRow previous;
            if (!DesignGridLayout.this._rows.isEmpty() && (previous = (AbstractRow)DesignGridLayout.this._rows.get(DesignGridLayout.this._rows.size() - 1)) instanceof GridRow) {
                return new GridRow((GridRow)previous);
            }
            return new GridRow(null);
        }
    }
}

