/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.designgridlayout;

import java.awt.Container;
import javax.swing.JComponent;
import net.java.dev.designgridlayout.MultiComponent;
import org.jdesktop.layout.LayoutStyle;

final class ComponentGapsHelper {
    private final LayoutStyle _style = LayoutStyle.getSharedInstance();

    ComponentGapsHelper() {
    }

    public static ComponentGapsHelper instance() {
        return new ComponentGapsHelper();
    }

    public int getVerticalGap(JComponent component1, JComponent component2, int type, Container parent) {
        if (component1 instanceof MultiComponent) {
            MultiComponent multi = (MultiComponent)component1;
            int gap = 0;
            for (JComponent child : multi.getChildren()) {
                gap = Math.max(gap, this.getVerticalGap(child, component2, type, parent));
            }
            return gap;
        }
        if (component2 instanceof MultiComponent) {
            MultiComponent multi = (MultiComponent)component2;
            int gap = 0;
            for (JComponent child : multi.getChildren()) {
                gap = Math.max(gap, this.getVerticalGap(component1, child, type, parent));
            }
            return gap;
        }
        return this._style.getPreferredGap(component1, component2, type, 5, parent);
    }

    public int getHorizontalGap(JComponent component1, JComponent component2, int type, Container parent) {
        if (component1 instanceof MultiComponent) {
            MultiComponent multi = (MultiComponent)component1;
            int size = multi.getChildren().length;
            if (size > 0) {
                return this.getHorizontalGap(multi.getChildren()[size - 1], component2, type, parent);
            }
            return 0;
        }
        if (component2 instanceof MultiComponent) {
            MultiComponent multi = (MultiComponent)component2;
            int size = multi.getChildren().length;
            if (size > 0) {
                return this.getHorizontalGap(component1, multi.getChildren()[0], type, parent);
            }
            return 0;
        }
        return this._style.getPreferredGap(component1, component2, type, 3, parent);
    }

    public int getNorthContainerGap(JComponent component, Container parent) {
        if (component instanceof MultiComponent) {
            MultiComponent multi = (MultiComponent)component;
            int gap = 0;
            for (JComponent child : multi.getChildren()) {
                gap = Math.max(gap, this.getNorthContainerGap(child, parent));
            }
            return gap;
        }
        return this._style.getContainerGap(component, 1, parent);
    }

    public int getSouthContainerGap(JComponent component, Container parent) {
        if (component instanceof MultiComponent) {
            MultiComponent multi = (MultiComponent)component;
            int gap = 0;
            for (JComponent child : multi.getChildren()) {
                gap = Math.max(gap, this.getSouthContainerGap(child, parent));
            }
            return gap;
        }
        return this._style.getContainerGap(component, 5, parent);
    }

    public int getWestContainerGap(JComponent component, Container parent) {
        if (component instanceof MultiComponent) {
            MultiComponent multi = (MultiComponent)component;
            if (multi.getChildren().length > 0) {
                return this.getWestContainerGap(multi.getChildren()[0], parent);
            }
            return 0;
        }
        return this._style.getContainerGap(component, 7, parent);
    }

    public int getEastContainerGap(JComponent component, Container parent) {
        if (component instanceof MultiComponent) {
            MultiComponent multi = (MultiComponent)component;
            int size = multi.getChildren().length;
            if (size > 0) {
                return this.getEastContainerGap(multi.getChildren()[size - 1], parent);
            }
            return 0;
        }
        return this._style.getContainerGap(component, 3, parent);
    }
}

