/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.designgridlayout;

import java.awt.Container;
import java.util.List;
import javax.swing.JComponent;
import net.java.dev.designgridlayout.BaselineExtractor;
import net.java.dev.designgridlayout.ComponentHelper;
import net.java.dev.designgridlayout.HeightGrowPolicy;
import net.java.dev.designgridlayout.IExtractor;
import net.java.dev.designgridlayout.IRowItem;
import net.java.dev.designgridlayout.LayoutHelper;
import net.java.dev.designgridlayout.OrientationPolicy;
import net.java.dev.designgridlayout.PrefHeightExtractor;
import net.java.dev.designgridlayout.PrefWidthExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractRow {
    private Container _parent;
    private HeightGrowPolicy _heightTester;
    private OrientationPolicy _orientation;
    private boolean _unrelatedGap = false;
    private int _vgap = 0;
    private int _baseline;
    private int _height;
    private double _growWeight = -1.0;
    private int _maxWidth;
    private int _actualHeight;

    AbstractRow() {
    }

    final void init(Container parent, HeightGrowPolicy heightTester, OrientationPolicy orientation) {
        this._parent = parent;
        this._heightTester = heightTester;
        this._orientation = orientation;
    }

    protected final Container parent() {
        return this._parent;
    }

    protected final HeightGrowPolicy growPolicy() {
        return this._heightTester;
    }

    protected final OrientationPolicy orientation() {
        return this._orientation;
    }

    final void setUnrelatedGap() {
        this._unrelatedGap = true;
    }

    final boolean hasUnrelatedGap() {
        return this._unrelatedGap;
    }

    final void vgap(int vgap) {
        this._vgap = vgap;
    }

    final int vgap() {
        return this._vgap;
    }

    final void init() {
        this._maxWidth = ComponentHelper.maxValues(this.items(), PrefWidthExtractor.INSTANCE);
        this._height = ComponentHelper.maxValues(this.allItems(), PrefHeightExtractor.INSTANCE);
        this._baseline = ComponentHelper.maxValues(this.allItems(), BaselineExtractor.INSTANCE);
        boolean fixedHeight = ComponentHelper.isFixedHeight(this._heightTester, this.items());
        if (fixedHeight || this._growWeight == -1.0) {
            this._growWeight = fixedHeight ? 0.0 : 1.0;
        }
    }

    protected final int baseline() {
        return this._baseline;
    }

    protected final int maxWidth() {
        return this._maxWidth;
    }

    int height() {
        return this._height;
    }

    void actualHeight(int height) {
        this._actualHeight = height;
    }

    int actualHeight() {
        return this._actualHeight;
    }

    final void growWeight(double weight) {
        if (weight >= 0.0) {
            this._growWeight = weight;
        }
    }

    final double growWeight() {
        return this._growWeight;
    }

    int numGrids() {
        return 0;
    }

    void totalGrids(int totalGrids) {
    }

    int gridspan(int grid) {
        return 1;
    }

    int gridColumns(int grid) {
        return 0;
    }

    int labelWidth(int grid) {
        return 0;
    }

    int maxColumnWidth(int grid, int maxColumns, IExtractor extractor) {
        return 0;
    }

    int totalNonGridWidth(int hgap, IExtractor extractor) {
        return 0;
    }

    int hgap() {
        return ComponentHelper.hgap(this.allItems(), this.parent());
    }

    int gridgap() {
        return 0;
    }

    boolean isEmpty() {
        return this.allItems().isEmpty();
    }

    JComponent leftComponent() {
        return this.allItems().isEmpty() ? null : this.allItems().get(0).component();
    }

    JComponent rightComponent() {
        return this.allItems().isEmpty() ? null : this.allItems().get(this.allItems().size() - 1).component();
    }

    abstract void checkSpanRows();

    abstract List<? extends IRowItem> items();

    List<? extends IRowItem> allItems() {
        return this.items();
    }

    abstract int layoutRow(LayoutHelper var1, int var2, int var3, int var4, int var5, int var6, List<Integer> var7);
}

