/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.produktion;

import com.schneide.base.application.module.GenericModuleCreationInformation;
import com.schneide.base.application.module.ModuleFactory;
import com.schneide.base.application.module.ModuleStorage;
import com.schneide.base.application.module.creation.ConfigurableModuleCreationInformation;
import com.schneide.base.application.module.creation.ModuleSetup;
import com.schneide.base.util.Parameter;
import com.schneide.werp.module.datenimport.creation.DatenimportModuleFactory;
import com.schneide.werp.module.datenspeicherung.creation.DatenspeicherungModuleFactory;
import com.schneide.werp.module.render.pdf.PDFDokumenterstellung;
import com.schneide.werp.periphery.dokumenterstellung.Dokumenterstellung;
import com.schneide.werp.produktion.WerpApplicationProduktion;
import java.util.ArrayList;

public final class Main {
    private Main() {
    }

    public static void main(String[] args) {
        WerpApplicationProduktion application = WerpApplicationProduktion.prepare(Main::createModules, (Dokumenterstellung)new PDFDokumenterstellung());
        application.boot();
    }

    private static Iterable<ConfigurableModuleCreationInformation> createModules(ModuleSetup setup) {
        Parameter.isPresent((Object)setup);
        ArrayList<ConfigurableModuleCreationInformation> result = new ArrayList<ConfigurableModuleCreationInformation>();
        result.add((ConfigurableModuleCreationInformation)new GenericModuleCreationInformation(setup.configuration().getModuleConfigurationsFor(DatenimportModuleFactory.specification), (ModuleFactory)new DatenimportModuleFactory(setup.environment()), (ModuleStorage)setup.periphery()));
        result.add((ConfigurableModuleCreationInformation)new GenericModuleCreationInformation(setup.configuration().getModuleConfigurationsFor(DatenspeicherungModuleFactory.specification), (ModuleFactory)new DatenspeicherungModuleFactory(setup.environment()), (ModuleStorage)setup.periphery()));
        return result;
    }
}

