/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.util.filter;

import com.schneide.base.datatypes.collections.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class FilterArray {
    private FilterArray() {
    }

    public static <T> List<T> withList(ArrayFilter<T> visitor, Collection<T> array, Class<T> clazz) {
        if (array == null || array.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> filteredElements = new ArrayList<T>();
        for (T channel : array) {
            if (!visitor.accept(channel)) continue;
            filteredElements.add(channel);
        }
        return filteredElements;
    }

    public static <T> T[] with(ArrayFilter<T> visitor, Collection<T> array, Class<T> clazz) {
        List<T> result = FilterArray.withList(visitor, array, clazz);
        return result.toArray(ArrayUtil.createArray(clazz, result.size()));
    }

    public static <T> T[] with(ArrayFilter<T> visitor, T[] array, Class<T> clazz) {
        if (ArrayUtil.isEmptyOrNull(array)) {
            return ArrayUtil.createArray(clazz, 0);
        }
        return FilterArray.with(visitor, Arrays.asList(array), clazz);
    }

    public static <T> T[] fromNullValues(T[] array, Class<T> clazz) {
        return FilterArray.with((T element) -> null != element, array, clazz);
    }

    public static interface ArrayFilter<E> {
        public boolean accept(E var1);
    }
}

