/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.util.filter;

import com.schneide.base.datatypes.collections.iterable.SingleElementIterable;
import com.schneide.base.i18n.I18NKey;
import com.schneide.base.i18n.I18NText;
import com.schneide.base.i18n.model.I18NResolvable;
import com.schneide.base.util.EqualsBuilder;
import com.schneide.base.util.filter.AbstractReadableFilter;
import com.schneide.base.util.filter.FilterVisitor;

public abstract class AbstractParameterizableFilter<E, P>
extends AbstractReadableFilter<E> {
    private final P parameter;

    protected AbstractParameterizableFilter(P parameter) {
        this.parameter = parameter;
    }

    @Override
    public <V> V acceptVisitor(FilterVisitor<V> visitor) {
        return visitor.visit(this);
    }

    public P getParameter() {
        return this.parameter;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.isEqual(this, obj);
    }

    public int hashCode() {
        return EqualsBuilder.hashCodeFor(this);
    }

    public Iterable<Object> getValuesToCompare() {
        return new SingleElementIterable<Object>(this.parameter);
    }

    public abstract I18NKey getDenotationKey();

    @Override
    public I18NResolvable getDenotation() {
        return new I18NText(this.getDenotationKey(), this.getParameter());
    }
}

