/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.util;

import java.util.Arrays;
import java.util.Iterator;

public final class EqualsBuilder {
    private EqualsBuilder() {
    }

    public static int hashCodeFor(EqualComparable one) {
        if (null == one) {
            return 0;
        }
        int prime = 31;
        int result = 1;
        for (Object o : one.getValuesToCompare()) {
            result = 31 * result + EqualsBuilder.calculateHashCode(o);
        }
        return result;
    }

    private static int calculateHashCode(Object o) {
        if (null == o) {
            return 0;
        }
        if (o.getClass().isArray()) {
            return Arrays.hashCode((Object[])o);
        }
        return o.hashCode();
    }

    public static boolean isEqual(EqualComparable one, Object two) throws IllegalArgumentException {
        if (null == one || null == two) {
            return false;
        }
        if (!one.getClass().isInstance(two)) {
            return false;
        }
        Iterable<?> valuesToCompareOfOne = one.getValuesToCompare();
        Iterable<?> valuesToCompareOfTwo = ((EqualComparable)two).getValuesToCompare();
        if (null == valuesToCompareOfOne || null == valuesToCompareOfTwo) {
            throw new IllegalArgumentException("List of comparable values must not be null");
        }
        Iterator<?> firstValues = valuesToCompareOfOne.iterator();
        Iterator<?> secondValues = valuesToCompareOfTwo.iterator();
        while (firstValues.hasNext()) {
            Object second;
            if (!secondValues.hasNext()) {
                return false;
            }
            Object first = firstValues.next();
            if (EqualsBuilder.areEqual(first, second = secondValues.next())) continue;
            return false;
        }
        return !secondValues.hasNext();
    }

    protected static boolean areEqual(Object objectOne, Object objectTwo) {
        if (null == objectOne) {
            return null == objectTwo;
        }
        if (null == objectTwo) {
            return false;
        }
        if (objectOne.getClass().isArray() && objectTwo.getClass().isArray()) {
            return Arrays.equals((Object[])objectOne, (Object[])objectTwo);
        }
        return objectOne.equals(objectTwo);
    }

    public static interface EqualComparable {
        public Iterable<?> getValuesToCompare();
    }
}

