/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.timing;

import com.schneide.base.logging.LoggedObject;
import com.schneide.base.timing.DateFormatProvider;
import java.text.DateFormat;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;

public final class Clock
extends LoggedObject {
    private static final double NANOS_IN_MILLI = 1000000.0;
    private static volatile DateTime fixedNow;

    private Clock() {
    }

    public static String getFullYearString() {
        return DateFormatProvider.getFullYearFormat().format(Clock.nowAsDate());
    }

    public static String getShortYearString() {
        return DateFormatProvider.getHalfYearFormat().format(Clock.nowAsDate());
    }

    public static String getYearString() {
        return Clock.getFullYearString();
    }

    public static DateFormat getTimeIndexFormat() {
        return DateFormatProvider.getStandardIndexFormat();
    }

    public static String getTimeIndexString() {
        return Clock.getTimeIndexFormat().format(Clock.nowAsDate());
    }

    public static String getTimeIndexString(Date date) {
        return Clock.getTimeIndexFormat().format(date);
    }

    public static String getFullIndexString() {
        return Clock.getFullIndexStringFor(Clock.nowAsDate());
    }

    public static String getFullIndexStringFor(Date date) {
        return DateFormatProvider.getFullIndexFormat().format(date);
    }

    public static long getTimeInMilliseconds() {
        if (null != fixedNow) {
            return fixedNow.getMillis();
        }
        return System.currentTimeMillis();
    }

    public static long getHighPrecisionRelativeMilliseconds() {
        if (null != fixedNow) {
            return fixedNow.getMillis();
        }
        return Clock.getMillisecondsFromNanoseconds(System.nanoTime());
    }

    private static long getMillisecondsFromNanoseconds(long nanoseconds) {
        return (long)((double)nanoseconds / 1000000.0);
    }

    public static String getDateTimeString() {
        return Clock.getDateTimeStringFor(Clock.nowAsDate());
    }

    public static String getDateTimeStringFor(Date date) {
        return DateFormatProvider.getStandardDateTimeFormat().format(date);
    }

    public static String getDateString() {
        return DateFormatProvider.getStandardDateTimeFormat().format(Clock.nowAsDate());
    }

    public static Date nowAsDate() {
        return Clock.now().toDate();
    }

    public static void setFixedNow(DateTime newNow) {
        fixedNow = newNow;
    }

    public static void clearFixation() {
        Clock.setFixedNow(null);
    }

    public static DateTime now() {
        if (null == fixedNow) {
            return new DateTime();
        }
        return fixedNow;
    }

    public static Interval getInterval(LocalTime start, LocalTime end) {
        DateTime midnight = Clock.now().withTimeAtStartOfDay();
        return new Interval((ReadableInstant)start.toDateTime((ReadableInstant)midnight), (ReadableInstant)end.toDateTime((ReadableInstant)midnight));
    }

    public static Interval getAllDay() {
        return Clock.getInterval(new LocalTime(0, 0), new LocalTime(23, 59, 59, 999));
    }
}

