/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.threading;

import com.schneide.base.logging.Logger;
import com.schneide.base.system.Base;
import javax.measure.Measurable;
import javax.measure.quantity.Duration;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;

public class SchneideThread
extends Thread {
    private static final String INTERRUPTED_THREAD_LOG_MESSAGE = "Interrupted thread.";
    private static final ThreadGroup SCHNEIDE_THREADS = new ThreadGroup("SchneideThreads"){

        private Logger getLogger() {
            return Base.getLogger(this);
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            super.uncaughtException(t, e);
            this.getLogger().error("Ein bisher nicht behandelter Fehlerzustand ist aufgetreten. (Thread=" + t.getName() + ")", e);
            this.getLogger().info("Genaue Fehleranalyse:", e.getCause());
        }
    };
    private static final int NORMAL_PRIORITY = 5;
    private static final boolean VERBOSE_WAIT_DEBUG = false;
    private static final boolean PRINT_WAIT_STACKTRACES = false;
    private boolean isAlive;
    private boolean isBackgroundThread;
    private boolean isVerbose;

    public SchneideThread(String name) {
        this(name, false);
    }

    public SchneideThread(String name, boolean isBackgroundThread) {
        super(SCHNEIDE_THREADS, name);
        this.isBackgroundThread = isBackgroundThread;
        this.isAlive = false;
        this.isVerbose = false;
    }

    public SchneideThread(Runnable runnable, String name) {
        super(SCHNEIDE_THREADS, runnable, name);
        this.isBackgroundThread = false;
        this.isAlive = false;
        this.isVerbose = false;
    }

    public void setVerbose(boolean state) {
        this.isVerbose = state;
    }

    public boolean isVerbose() {
        return this.isVerbose;
    }

    protected final Logger getLogger() {
        return Base.getLogger(this);
    }

    public final void setThreadName(String name) {
        super.setName(name);
    }

    public final boolean startThread() {
        return this.startThread(5);
    }

    public final boolean startThread(int priority) {
        this.isAlive = true;
        if (this.isAlive) {
            this.start();
        }
        this.setPriority(priority);
        if (this.isVerbose()) {
            this.getLogger().debug("Thread " + this.getName() + " [" + this.getPriority() + "] startet mit: " + this.isAlive);
        }
        return this.isAlive;
    }

    public final boolean setRunning() {
        return this.startThread();
    }

    public final boolean setRunning(int priority) {
        return this.startThread(priority);
    }

    public final void stopRunning() {
        this.stopThread();
    }

    public final void stopThread() {
        if (this.isVerbose()) {
            this.getLogger().debug("Thread " + this.getName() + " [" + this.getPriority() + "] mit sofortiger Wirkung gestoppt.");
        }
        this.isAlive = false;
    }

    public final boolean isThreadAlive() {
        return this.isAlive;
    }

    public final boolean shouldBeRunning() {
        return this.isAlive;
    }

    public boolean isBackgroundThread() {
        return this.isBackgroundThread;
    }

    public void setBackgroundThread(boolean backgroundState) {
        this.isBackgroundThread = backgroundState;
    }

    public static SchneideThread createWorkerThread(String name, Runnable runnable) {
        SchneideThread result = new SchneideThread(runnable, name);
        return result;
    }

    public static boolean startWorker(String name, Runnable runnable) {
        SchneideThread thread = SchneideThread.createWorkerThread(name, runnable);
        return thread.startThread();
    }

    public static void performDelay(Measurable<Duration> delay) {
        SchneideThread.performDelay(delay.longValue(SI.MILLI((Unit)SI.SECOND)));
    }

    public static void warteSekunden(int sekunden) {
        SchneideThread.performDelay((long)sekunden * 1000L);
    }

    public static void warteEineSekunde() {
        SchneideThread.warteSekunden(1);
    }

    public static void performDelay(java.time.Duration dauer) {
        SchneideThread.performDelay(dauer.toMillis());
    }

    public static void performDelay(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            SchneideThread.getStaticLogger().warn(INTERRUPTED_THREAD_LOG_MESSAGE, e);
            Thread.currentThread().interrupt();
        }
    }

    private static Logger getStaticLogger() {
        return Base.getLogger(SchneideThread.class);
    }

    public static void performIndefiniteWaitOn(Object lock) {
        SchneideThread.performIndefiniteWaitOn(lock, INTERRUPTED_THREAD_LOG_MESSAGE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void performIndefiniteWaitOn(Object lock, String interruptionMessage) {
        Object object = lock;
        synchronized (object) {
            try {
                SchneideThread.verboseDebug("Going into waitstate: " + Thread.currentThread().getName());
                lock.wait();
                SchneideThread.verboseDebug("Recovering from waitstate: " + Thread.currentThread().getName());
            }
            catch (InterruptedException e) {
                SchneideThread.handleInterruptedException(interruptionMessage, e);
            }
        }
    }

    public static void handleInterruptedException(InterruptedException e) {
        SchneideThread.handleInterruptedException(INTERRUPTED_THREAD_LOG_MESSAGE, e);
    }

    public static void handleInterruptedException(String interruptionMessage, InterruptedException e) {
        Thread.currentThread().interrupt();
        SchneideThread.getStaticLogger().warn(interruptionMessage, e);
    }

    private static void verboseDebug(String message) {
    }
}

