/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.threading;

import com.schneide.base.logging.LoggedObject;
import com.schneide.base.threading.ExceptionListener;
import com.schneide.base.threading.SchneideThread;
import java.util.ArrayList;
import java.util.List;

public abstract class Executable
extends LoggedObject
implements Thread.UncaughtExceptionHandler {
    private boolean isExecuting;
    private boolean isStopRequested;
    private final SchneideThread thread;
    private Throwable occurredException;
    private final List<ExceptionListener> exceptionListenerList;
    private boolean isLoggingExceptions;

    public Executable(String name) {
        this(name, false);
    }

    public Executable(String name, boolean isBackgroundActivity) {
        this.thread = new ExecutionThread(name, isBackgroundActivity);
        this.thread.setUncaughtExceptionHandler(this);
        this.occurredException = null;
        this.isExecuting = false;
        this.isStopRequested = false;
        this.isLoggingExceptions = true;
        this.exceptionListenerList = new ArrayList<ExceptionListener>();
    }

    public final void setLoggingExceptions(boolean newState) {
        this.isLoggingExceptions = newState;
    }

    public final boolean isLoggingExceptions() {
        return this.isLoggingExceptions;
    }

    public final boolean isBackgroundActivity() {
        return this.getThread().isBackgroundThread();
    }

    public final void setBackgroundActivity(boolean isBackgroundActivity) {
        this.getThread().setBackgroundThread(isBackgroundActivity);
    }

    @Override
    public void uncaughtException(Thread currentThread, Throwable exception) {
        this.setOccurredException(exception);
        if (this.isLoggingExceptions()) {
            this.logException(currentThread, exception);
        }
        this.notifyExceptionOccured(exception);
    }

    protected void logException(Thread currentThread, Throwable exception) {
        this.getLogger().error("Exception occurred within executable process " + String.valueOf(currentThread), exception);
    }

    private synchronized void setOccurredException(Throwable e) {
        this.occurredException = e;
    }

    protected synchronized void setExecutionState(boolean state) {
        this.isExecuting = state;
    }

    public final synchronized SchneideThread getThread() {
        return this.thread;
    }

    public final synchronized boolean isBoundForTermination() {
        return !this.getThread().isThreadAlive();
    }

    public final synchronized boolean isStopRequested() {
        return this.isStopRequested;
    }

    public final synchronized boolean isExecuting() {
        return this.isExecuting;
    }

    public final synchronized void stopExecution() {
        this.isStopRequested = true;
        this.getThread().stopThread();
    }

    public final synchronized void stopWithInterrupt() {
        this.stopExecution();
        this.getThread().interrupt();
    }

    public final synchronized void startExecution() {
        this.getThread().startThread();
    }

    public final synchronized boolean hasExceptionOccurred() {
        return this.getOccurredException() != null;
    }

    public final synchronized Throwable getOccurredException() {
        return this.occurredException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyExceptionOccured(Throwable e) {
        List<ExceptionListener> list = this.exceptionListenerList;
        synchronized (list) {
            for (ExceptionListener listener : this.exceptionListenerList) {
                listener.notifyException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExceptionListener(ExceptionListener exceptionListener) {
        if (null == exceptionListener) {
            return;
        }
        List<ExceptionListener> list = this.exceptionListenerList;
        synchronized (list) {
            this.exceptionListenerList.add(exceptionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExceptionListener(ExceptionListener exceptionListener) {
        List<ExceptionListener> list = this.exceptionListenerList;
        synchronized (list) {
            this.exceptionListenerList.remove(exceptionListener);
        }
    }

    protected abstract void execute() throws Exception;

    protected class ExecutionThread
    extends SchneideThread {
        public ExecutionThread(String name, boolean isBackgroundThread) {
            super(name, isBackgroundThread);
        }

        @Override
        public void run() {
            Executable.this.setExecutionState(true);
            try {
                Executable.this.execute();
            }
            catch (Throwable e) {
                Executable.this.uncaughtException(this, e);
            }
            finally {
                Executable.this.setExecutionState(false);
            }
        }
    }
}

