/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.text.transformation;

import com.schneide.base.text.transformation.StringTransformation;

public class SuffixTrim
implements StringTransformation {
    private final String suffixPattern;

    public SuffixTrim(String suffixPattern) {
        this.suffixPattern = suffixPattern;
    }

    @Override
    public String transform(String string) {
        String result = string;
        if (this.suffixPattern != null && this.suffixPattern.length() > 0) {
            while (result.length() >= this.suffixPattern.length() && result.endsWith(this.suffixPattern)) {
                result = result.substring(0, result.length() - this.suffixPattern.length());
            }
        }
        return result;
    }

    public String getSuffixPattern() {
        return this.suffixPattern;
    }
}

