/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.text.transformation;

import com.schneide.base.text.transformation.StringTransformation;
import com.schneide.base.util.Parameter;

public class RegExReplacement
implements StringTransformation {
    private final String pattern;
    private final String replacementPattern;

    public RegExReplacement(String pattern, String replacement) {
        Parameter.isPresent("Replacement string", replacement);
        Parameter.isPresent("Pattern string", pattern);
        this.pattern = pattern;
        this.replacementPattern = replacement;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getReplacementPattern() {
        return this.replacementPattern;
    }

    @Override
    public String transform(String target) {
        if (target == null) {
            return null;
        }
        return target.replaceAll(this.getPattern(), this.getReplacementPattern());
    }
}

