/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.text.transformation;

import com.schneide.base.text.Text;

public final class Embrace {
    private Embrace() {
    }

    public static String withRoundBrackets(Object text) {
        return Embrace.withBrackets("(", ")", text);
    }

    public static String withParentheses(Object text) {
        return Embrace.withRoundBrackets(text);
    }

    public static String withSquareBrackets(Object text) {
        return Embrace.withBrackets("[", "]", text);
    }

    public static String withBraces(Object text) {
        return Embrace.withCurlyBrackets(text);
    }

    public static String withCurlyBrackets(Object text) {
        return Embrace.withBrackets("{", "}", text);
    }

    public static String withAngleBrackets(Object text) {
        return Embrace.withBrackets("<", ">", text);
    }

    public static String withQuotationMarks(Object text) {
        return Embrace.withDoubleQuotes(text);
    }

    public static String withDoubleQuotes(Object text) {
        return Embrace.withCharacter("\"", text);
    }

    public static String withSingleQuotes(Object text) {
        return Embrace.withCharacter("'", text);
    }

    public static String withCharacter(String character, Object text) {
        return Embrace.withBrackets(character, character, text);
    }

    public static String withString(String string, Object text) {
        return Embrace.withBrackets(string, string, text);
    }

    public static String withReversableString(String string, Object text) {
        return Embrace.withBrackets(string, Text.reverse(string), text);
    }

    public static String withBrackets(String openingBracket, String closingBracket, Object text) {
        StringBuilder result = new StringBuilder();
        result.append(openingBracket);
        result.append(String.valueOf(text));
        result.append(closingBracket);
        return result.toString();
    }

    public static String withXMLTag(String text, String tagName) {
        return Embrace.withBrackets(Embrace.withAngleBrackets(tagName), Embrace.withAngleBrackets("/" + tagName), text);
    }

    public static String withHTMLTag(String text, String tagName) {
        return Embrace.withXMLTag(text, tagName);
    }
}

