/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.text.parsing;

import java.text.ParseException;
import java.util.ArrayList;

public class LineParser {
    public String[] splitArguments(String line) throws ParseException {
        if (line == null) {
            throw new ParseException("Keine Zeile zu parsen.", 0);
        }
        ArrayList<String> argumentsList = new ArrayList<String>();
        int cursorIndex = -1;
        boolean inQuote = false;
        while (cursorIndex + 1 < line.length()) {
            ++cursorIndex;
            String token = "";
            if (inQuote) {
                int quoteIndex = line.indexOf(34, cursorIndex);
                token = -1 == quoteIndex ? line.substring(cursorIndex, line.length()) : line.substring(cursorIndex, quoteIndex);
                inQuote = false;
            } else {
                int blankIndex = line.indexOf(32, cursorIndex);
                int quoteIndex = line.indexOf(34, cursorIndex);
                if (blankIndex < 0) {
                    blankIndex = line.length();
                }
                int tokenEndIndex = blankIndex;
                if (quoteIndex < blankIndex && quoteIndex >= 0) {
                    inQuote = true;
                    tokenEndIndex = quoteIndex;
                }
                token = line.substring(cursorIndex, tokenEndIndex);
            }
            if (token.length() > 0) {
                argumentsList.add(token);
            }
            cursorIndex += token.length();
        }
        return argumentsList.toArray(new String[argumentsList.size()]);
    }
}

