/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.text.buffer;

import com.schneide.base.text.buffer.ChunkBuffer;
import com.schneide.base.util.Parameter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LazyChunkBuffer
implements ChunkBuffer {
    private final List<Token> tokenList;
    private final CharSequence separator;

    public LazyChunkBuffer(char separator) {
        this(String.valueOf(separator));
    }

    public LazyChunkBuffer(CharSequence separator) {
        this(separator, new ArrayList<Token>());
    }

    protected LazyChunkBuffer(CharSequence separator, List<Token> tokenList) {
        Parameter.arePresent(separator, tokenList);
        this.tokenList = tokenList;
        this.separator = separator;
    }

    protected final List<Token> getTokenList() {
        return this.tokenList;
    }

    @Override
    public void add(int value) {
        this.append(value);
    }

    @Override
    public void add(Object chunkObject) {
        this.append(chunkObject);
    }

    @Override
    public void add(CharSequence chunk) {
        this.append(chunk);
    }

    @Override
    public void append(int value) {
        this.append(String.valueOf(value));
    }

    @Override
    public void append(Object chunkObject) {
        this.append(String.valueOf(chunkObject));
    }

    @Override
    public boolean isEmpty() {
        return this.getTokenList().isEmpty();
    }

    @Override
    public String getSeparator() {
        return this.separator.toString();
    }

    @Override
    public void append(CharSequence token) {
        this.appendToken(new Token(token));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void appendToken(Token token) {
        List<Token> list = this.getTokenList();
        synchronized (list) {
            this.getTokenList().add(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder result = new StringBuilder();
        List<Token> list = this.getTokenList();
        synchronized (list) {
            Iterator<Token> iterator = this.getTokenList().iterator();
            if (iterator.hasNext()) {
                Token lastToken = iterator.next();
                result.append(lastToken);
                while (iterator.hasNext()) {
                    Token nextToken = iterator.next();
                    if (!lastToken.isSeparator()) {
                        result.append(this.getSeparator());
                    }
                    result.append(nextToken);
                    lastToken = nextToken;
                }
            }
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getChunks() {
        String[] result;
        List<Token> list = this.getTokenList();
        synchronized (list) {
            result = new String[this.getTokenList().size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = String.valueOf(this.getTokenList().get(i));
            }
        }
        return result;
    }

    @Override
    public void addSeparator() {
        this.appendSeparator();
    }

    @Override
    public void appendSeparator() {
        this.getTokenList().add(new Token(this.getSeparator(), true));
    }

    protected static class Token {
        private final CharSequence text;
        private final boolean isSeparator;

        public Token(CharSequence text) {
            this(text, false);
        }

        public Token(CharSequence text, boolean isSeparator) {
            this.text = text;
            this.isSeparator = isSeparator;
        }

        public CharSequence getText() {
            return this.text;
        }

        public boolean isSeparator() {
            return this.isSeparator;
        }

        public String toString() {
            return String.valueOf(this.getText());
        }
    }
}

