/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.text.buffer;

import com.schneide.base.text.buffer.ChunkBuffer;
import com.schneide.base.util.Parameter;

public class DirectChunkBuffer
implements ChunkBuffer {
    private final CharSequence separator;
    private final StringBuilder buffer;
    private final boolean isSeparatingWhenChunkEmpty;
    private boolean hasChunks;

    public DirectChunkBuffer(char separatorChar) {
        this(separatorChar, true);
    }

    public DirectChunkBuffer(char separatorChar, boolean isSeparatingWhenChunkEmpty) {
        this(String.valueOf(separatorChar), isSeparatingWhenChunkEmpty);
    }

    public DirectChunkBuffer(CharSequence chunkSeparator) {
        this(chunkSeparator, true);
    }

    public DirectChunkBuffer(CharSequence chunkSeparator, boolean isSeparatingWhenChunkEmpty) {
        Parameter.isPresent(chunkSeparator);
        this.buffer = new StringBuilder();
        this.separator = chunkSeparator;
        this.isSeparatingWhenChunkEmpty = isSeparatingWhenChunkEmpty;
        this.hasChunks = false;
    }

    public boolean isSeparatingOnEmptyChunk() {
        return this.isSeparatingWhenChunkEmpty;
    }

    private StringBuilder getBuffer() {
        return this.buffer;
    }

    @Override
    public String getSeparator() {
        return this.separator.toString();
    }

    public DirectChunkBuffer addAll(Iterable<?> chunks) {
        for (Object object : chunks) {
            this.append(object);
        }
        return this;
    }

    @Override
    public void add(CharSequence chunk) {
        this.append(chunk);
    }

    private boolean isEmptyChunk(CharSequence chunk) {
        return null != chunk && 0 == chunk.length();
    }

    @Override
    public void append(CharSequence chunk) {
        if (this.hasChunks && (!this.isEmptyChunk(chunk) || this.isSeparatingOnEmptyChunk())) {
            this.getBuffer().append(this.getSeparator());
        }
        this.getBuffer().append(chunk);
        this.hasChunks = true;
    }

    public void insertWithoutChunking(String text) {
        this.getBuffer().append(text);
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.getBuffer().length();
    }

    public String toString() {
        return this.asString();
    }

    public String asString() {
        return this.getBuffer().toString();
    }

    @Override
    public void add(Object chunkObject) {
        this.append(chunkObject);
    }

    @Override
    public void append(Object chunkObject) {
        this.append(String.valueOf(chunkObject));
    }

    @Override
    public void add(int value) {
        this.append(value);
    }

    @Override
    public void append(int value) {
        this.append(String.valueOf(value));
    }

    public void add(long value) {
        this.append(value);
    }

    public void append(long value) {
        this.append(String.valueOf(value));
    }

    @Override
    public void addSeparator() {
        this.appendSeparator();
    }

    @Override
    public void appendSeparator() {
        this.insertWithoutChunking(this.getSeparator());
    }
}

