/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.text;

import com.schneide.base.datatypes.collections.ArrayUtil;
import com.schneide.base.text.buffer.DirectChunkBuffer;
import com.schneide.base.text.parsing.StringChunker;
import com.schneide.base.util.StringProvider;
import java.util.ArrayList;
import java.util.Arrays;

public final class StringUtil {
    private StringUtil() {
    }

    public static boolean isEmptyOrNull(String s) {
        return null == s || s.trim().length() == 0;
    }

    public static String stripSpacesDownToOne(String s) {
        return s.replaceAll("[ ]+", " ");
    }

    public static <T> boolean containsIgnoreCase(Iterable<T> objects, String instance, StringProvider<T> provider) {
        if (null == objects || null == instance) {
            return false;
        }
        for (T element : objects) {
            if (!instance.equalsIgnoreCase(provider.getAsString(element))) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean containsIgnoreCase(T[] array, String instance, StringProvider<T> provider) {
        if (null == instance || ArrayUtil.isEmptyOrNull(array)) {
            return false;
        }
        return StringUtil.containsIgnoreCase(Arrays.asList(array), instance, provider);
    }

    public static boolean containsIgnoreCase(Iterable<String> strings, String instance) {
        if (null == strings || null == instance) {
            return false;
        }
        for (String element : strings) {
            if (!instance.equalsIgnoreCase(element)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsIgnoreCase(String[] array, String instance) {
        if (null == instance || ArrayUtil.isEmptyOrNull(array)) {
            return false;
        }
        return StringUtil.containsIgnoreCase(Arrays.asList(array), instance);
    }

    public static String[] splitText(String text, int lineLength) {
        ArrayList<String> result = new ArrayList<String>();
        StringChunker chunker = new StringChunker(text, " ");
        DirectChunkBuffer currentChunk = new DirectChunkBuffer(" ");
        while (chunker.hasMoreChunks()) {
            String nextChunk = chunker.getNextChunk();
            currentChunk.add(nextChunk);
            if (((Object)currentChunk).toString().length() < lineLength) continue;
            result.add(((Object)currentChunk).toString());
            currentChunk = new DirectChunkBuffer(" ");
        }
        String currentChunkString = ((Object)currentChunk).toString();
        if (!currentChunkString.trim().isEmpty()) {
            result.add(currentChunkString);
        }
        return result.toArray(new String[result.size()]);
    }

    public static boolean endsWithOneOf(String text, String ... endings) {
        for (String string : endings) {
            if (!text.endsWith(string)) continue;
            return true;
        }
        return false;
    }

    public static String extractDigits(String text) {
        StringBuilder result = new StringBuilder();
        for (char character : text.toCharArray()) {
            if (!Character.isDigit(character)) continue;
            result.append(character);
        }
        return result.toString();
    }

    public static boolean isOnlyDigits(String text) {
        if (null == text || text.isEmpty()) {
            return false;
        }
        for (char character : text.toCharArray()) {
            if (Character.isDigit(character)) continue;
            return false;
        }
        return true;
    }
}

