/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.system.util;

import com.schneide.base.system.util.Megabyte;
import com.schneide.base.system.util.MemoryInformation;

public final class MemoryUsage {
    private MemoryUsage() {
    }

    public static synchronized MemoryInformation getCurrent() {
        return new MemoryUsageInformation(Runtime.getRuntime().totalMemory(), Runtime.getRuntime().freeMemory());
    }

    private static class MemoryUsageInformation
    implements MemoryInformation {
        private final long total;
        private final long free;
        private Megabyte totalMegabyte;
        private Megabyte freeMegabyte;
        private Megabyte usedMegabyte;

        public MemoryUsageInformation(long total, long free) {
            this.total = total;
            this.free = free;
        }

        @Override
        public synchronized Megabyte getFreeMemory() {
            if (this.freeMegabyte == null) {
                this.freeMegabyte = Megabyte.fromBytes(this.free);
            }
            return this.freeMegabyte;
        }

        @Override
        public synchronized Megabyte getTotalMemory() {
            if (this.totalMegabyte == null) {
                this.totalMegabyte = Megabyte.fromBytes(this.total);
            }
            return this.totalMegabyte;
        }

        @Override
        public synchronized Megabyte getUsedMemory() {
            if (this.usedMegabyte == null) {
                this.usedMegabyte = Megabyte.fromBytes(this.total - this.free);
            }
            return this.usedMegabyte;
        }
    }
}

