/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.settings.simple;

import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.logging.LoggedObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public abstract class FileBasedConfiguration
extends LoggedObject {
    private final VirtualFile file;
    private final Properties properties;

    public FileBasedConfiguration(VirtualFile file) {
        this.file = file;
        this.properties = new Properties();
    }

    protected InputStream getInputStream() throws IOException {
        return this.file.getInputStream();
    }

    public void reload() throws IOException {
        try (InputStream input = this.getInputStream();){
            this.properties.load(input);
        }
    }

    protected void loadIfNecessary() {
        if (!this.properties.isEmpty()) {
            return;
        }
        try {
            this.reload();
        }
        catch (IOException e) {
            this.getLogger().error("Could not load kabadra configuration file.", e);
        }
    }

    protected String getEntryFor(String key) {
        return this.getEntryFor(key, null);
    }

    protected String getEntryFor(String key, String fallbackValue) {
        this.loadIfNecessary();
        if (!this.properties.containsKey(key)) {
            return fallbackValue;
        }
        return this.properties.getProperty(key);
    }
}

