/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.properties.userLevel;

import com.schneide.base.datatypes.collections.iterable.SingleElementIterable;
import com.schneide.base.properties.ConfigurationPart;
import com.schneide.base.properties.applicationLevel.LongProperty;
import com.schneide.base.properties.applicationLevel.PropertyReferenceType;
import java.util.Optional;
import java.util.function.Consumer;

public class ConfiguredLong {
    private final Iterable<PropertyReferenceType> locations;
    private final Consumer<ConfigurationPart> preparation;
    private Optional<Long> usingFallback;

    public ConfiguredLong(PropertyReferenceType location, Consumer<ConfigurationPart> preparation) {
        this(new SingleElementIterable<PropertyReferenceType>(location), preparation);
    }

    public ConfiguredLong(Iterable<PropertyReferenceType> locations, Consumer<ConfigurationPart> preparation) {
        this.locations = locations;
        this.preparation = preparation;
        this.usingFallback = Optional.empty();
    }

    public ConfiguredLong withFallback(long fallback) {
        this.usingFallback = Optional.of(fallback);
        return this;
    }

    public Long in(ConfigurationPart configuration) {
        this.preparation.accept(configuration);
        for (PropertyReferenceType each : this.locations) {
            LongProperty maybeProperty = LongProperty.buildConfigured(configuration, each, this.defaultValue());
            if (!maybeProperty.hasValue()) continue;
            return maybeProperty.getValue();
        }
        return this.defaultValue();
    }

    public Optional<Long> maybeIn(ConfigurationPart configuration) {
        return Optional.ofNullable(this.in(configuration));
    }

    private Long defaultValue() {
        return this.usingFallback.orElse(null);
    }
}

