/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.properties.userLevel;

import com.schneide.base.datatypes.collections.iterable.SingleElementIterable;
import com.schneide.base.properties.ConfigurationPart;
import com.schneide.base.properties.Property;
import com.schneide.base.properties.applicationLevel.PropertyReferenceType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;

public class ConfiguredListOfStrings {
    private final Iterable<PropertyReferenceType> locations;
    private final Consumer<ConfigurationPart> preparation;
    private Optional<List<String>> usingFallback;

    public ConfiguredListOfStrings(PropertyReferenceType location, Consumer<ConfigurationPart> preparation) {
        this(new SingleElementIterable<PropertyReferenceType>(location), preparation);
    }

    public ConfiguredListOfStrings(Iterable<PropertyReferenceType> locations, Consumer<ConfigurationPart> preparation) {
        this.locations = locations;
        this.preparation = preparation;
        this.usingFallback = Optional.empty();
    }

    public ConfiguredListOfStrings withFallback(String ... fallback) {
        this.usingFallback = Optional.of(Arrays.asList(fallback));
        return this;
    }

    public Iterable<String> in(ConfigurationPart configuration) {
        this.preparation.accept(configuration);
        for (PropertyReferenceType each : this.locations) {
            if (!configuration.hasProperty(each.getKey())) continue;
            Property eintr\u00e4ge = configuration.getProperty(each.getKey());
            String[] values = eintr\u00e4ge.getValues();
            return Arrays.asList(values);
        }
        return this.defaultValue();
    }

    private Iterable<String> defaultValue() {
        return this.usingFallback.orElse(Collections.emptyList());
    }
}

