/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.properties.userLevel;

import com.schneide.base.datatypes.collections.iterable.SingleElementIterable;
import com.schneide.base.properties.ConfigurationPart;
import com.schneide.base.properties.applicationLevel.DoubleProperty;
import com.schneide.base.properties.applicationLevel.PropertyReferenceType;
import java.util.Optional;
import java.util.function.Consumer;

public class ConfiguredDouble {
    private final Iterable<PropertyReferenceType> locations;
    private final Consumer<ConfigurationPart> preparation;
    private Optional<Double> usingFallback;

    public ConfiguredDouble(PropertyReferenceType location, Consumer<ConfigurationPart> preparation) {
        this(new SingleElementIterable<PropertyReferenceType>(location), preparation);
    }

    public ConfiguredDouble(Iterable<PropertyReferenceType> locations, Consumer<ConfigurationPart> preparation) {
        this.locations = locations;
        this.preparation = preparation;
        this.usingFallback = Optional.empty();
    }

    public ConfiguredDouble withFallback(double fallback) {
        this.usingFallback = Optional.of(fallback);
        return this;
    }

    public Double in(ConfigurationPart configuration) {
        this.preparation.accept(configuration);
        return this.retrieveFrom(configuration).map(DoubleProperty::getValue).orElse(this.defaultValue());
    }

    public Optional<Double> maybeIn(ConfigurationPart configuration) {
        return Optional.ofNullable(this.in(configuration));
    }

    public void changeTo(double newValue, ConfigurationPart configuration) {
        Optional<DoubleProperty> property = this.retrieveFrom(configuration);
        property.ifPresent(p -> p.setValue(newValue));
        configuration.getConfiguration().commit();
    }

    private Double defaultValue() {
        return this.usingFallback.orElse(null);
    }

    private Optional<DoubleProperty> retrieveFrom(ConfigurationPart configuration) {
        this.preparation.accept(configuration);
        for (PropertyReferenceType each : this.locations) {
            DoubleProperty maybeProperty = DoubleProperty.buildConfigured(configuration, each, this.defaultValue());
            if (!maybeProperty.hasValue()) continue;
            return Optional.of(maybeProperty);
        }
        return Optional.empty();
    }
}

