/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.properties.userLevel;

import com.schneide.base.functional.No;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.properties.ConfigurationPart;
import com.schneide.base.properties.applicationLevel.PropertyReference;
import com.schneide.base.properties.applicationLevel.PropertyReferenceType;
import com.schneide.base.properties.userLevel.ConfiguredBoolean;
import com.schneide.base.properties.userLevel.ConfiguredDouble;
import com.schneide.base.properties.userLevel.ConfiguredInt;
import com.schneide.base.properties.userLevel.ConfiguredListOfStrings;
import com.schneide.base.properties.userLevel.ConfiguredLong;
import com.schneide.base.properties.userLevel.ConfiguredString;
import com.schneide.base.properties.userLevel.SuffixProvider;
import java.util.LinkedList;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class Configured
extends LoggedObject {
    private final LinkedList<String> possibleKeys = new LinkedList();
    private Optional<String> usingSection;
    private Consumer<ConfigurationPart> preparation;

    public Configured(String key) {
        this.possibleKeys.add(key);
        this.usingSection = Optional.empty();
        this.preparation = config -> config.getConfiguration().reload();
    }

    public static Configured entry(String key) {
        return new Configured(key);
    }

    public Configured inSection(String section) {
        this.usingSection = Optional.of(section);
        return this;
    }

    public Configured withoutReload() {
        this.preparation = No.op();
        return this;
    }

    public Configured suffixedWith(SuffixProvider suffix) {
        String originalKey = this.possibleKeys.peekLast();
        this.possibleKeys.add(0, originalKey + suffix.asSuffix().toUpperCase());
        this.possibleKeys.add(0, originalKey + suffix.asSuffix());
        return this;
    }

    private Iterable<PropertyReferenceType> atLocations() {
        if (this.usingSection.isPresent()) {
            return this.possibleKeys.stream().map(key -> PropertyReference.forKeyInSection(this.usingSection.get(), key)).collect(Collectors.toList());
        }
        return this.possibleKeys.stream().map(PropertyReference::forKey).collect(Collectors.toList());
    }

    public ConfiguredInt asInt() {
        return new ConfiguredInt(this.atLocations(), this.preparation);
    }

    public ConfiguredString asString() {
        return new ConfiguredString(this.atLocations(), this.preparation);
    }

    public ConfiguredListOfStrings asListOfStrings() {
        return new ConfiguredListOfStrings(this.atLocations(), this.preparation);
    }

    public ConfiguredBoolean asBoolean() {
        return new ConfiguredBoolean(this.atLocations(), this.preparation);
    }

    public ConfiguredDouble asDouble() {
        return new ConfiguredDouble(this.atLocations(), this.preparation);
    }

    public ConfiguredLong asLong() {
        return new ConfiguredLong(this.atLocations(), this.preparation);
    }
}

