/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.properties.fileLevel;

import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.properties.fileLevel.Comment;
import com.schneide.base.properties.fileLevel.PropertyEntry;
import com.schneide.base.properties.fileLevel.PropertyFileElement;
import com.schneide.base.properties.fileLevel.PropertyFileElementHolder;
import com.schneide.base.properties.fileLevel.PropertySection;
import com.schneide.base.properties.fileLevel.Whitespace;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.List;

public class PropertyFileParser {
    private static final List<String> commentLineOpeners = List.of("#", "!", "//");
    private static final String sectionOpener = "[";
    private static final String utf8_BOM = "\ufeff";
    private final Charset encoding;

    public PropertyFileParser(Charset encoding) {
        this.encoding = encoding;
    }

    public PropertyFileElementHolder parseContentOf(VirtualFile parsedFile) throws IOException {
        PropertyFileElementHolder result = new PropertyFileElementHolder();
        try (InputStreamReader fileInput = new InputStreamReader(parsedFile.getInputStream(), this.encoding);
             BufferedReader contentReader = new BufferedReader(fileInput);){
            String line = null;
            PropertySection currentSection = null;
            while ((line = contentReader.readLine()) != null) {
                PropertyFileElement element = this.parseFileElement(this.removeBOMFrom(line));
                if (element instanceof PropertySection) {
                    currentSection = (PropertySection)element;
                    result.addElement(currentSection);
                    continue;
                }
                if (currentSection != null) {
                    currentSection.addElement(element);
                    continue;
                }
                result.addElement(element);
            }
        }
        return result;
    }

    private PropertyFileElement parseFileElement(String line) {
        if (line == null) {
            return null;
        }
        String element = line.trim();
        if (element.length() < 1) {
            return new Whitespace(line);
        }
        if (this.isCommentLineStart(element)) {
            return new Comment(line);
        }
        if (this.isSectionLineStart(element)) {
            return new PropertySection(element);
        }
        return new PropertyEntry(element);
    }

    private boolean isSectionLineStart(String element) {
        return element.startsWith(sectionOpener);
    }

    private boolean isCommentLineStart(String element) {
        for (String each : commentLineOpeners) {
            if (!element.startsWith(each)) continue;
            return true;
        }
        return false;
    }

    private String removeBOMFrom(String text) {
        if (text.startsWith(utf8_BOM)) {
            return text.substring(1);
        }
        return text;
    }
}

