/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.properties.fileLevel;

import com.schneide.base.properties.fileLevel.PropertyFileElement;
import com.schneide.base.properties.fileLevel.Whitespace;
import com.schneide.base.text.TextBuffer;
import java.util.ArrayList;
import java.util.List;

class PropertyFileElementHolder {
    private final List<PropertyFileElement> elementList = new ArrayList<PropertyFileElement>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllFrom(PropertyFileElementHolder other) {
        if (other == null) {
            return;
        }
        List<PropertyFileElement> list = this.elementList;
        synchronized (list) {
            other.getElements().forEach(this::addElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addElement(PropertyFileElement element) {
        if (element == null) {
            return;
        }
        List<PropertyFileElement> list = this.elementList;
        synchronized (list) {
            this.elementList.add(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElement(PropertyFileElement element) {
        List<PropertyFileElement> list = this.elementList;
        synchronized (list) {
            this.removeLeadingWhitespaceFor(element);
            this.elementList.remove(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeLeadingWhitespaceFor(PropertyFileElement element) {
        List<PropertyFileElement> list = this.elementList;
        synchronized (list) {
            if (!element.leadingWhitespaceIsAssociated()) {
                return;
            }
            int currentIndex = this.elementList.indexOf(element) - 1;
            while (currentIndex >= 0 && this.elementList.get(currentIndex) instanceof Whitespace) {
                this.elementList.remove(currentIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<PropertyFileElement> getElements() {
        List<PropertyFileElement> list = this.elementList;
        synchronized (list) {
            return List.copyOf(this.elementList);
        }
    }

    public void dropDeletedElements() {
        for (PropertyFileElement each : this.getElements()) {
            if (!each.isDeleted()) continue;
            this.removeElement(each);
        }
    }

    public String toString() {
        TextBuffer result = new TextBuffer();
        for (PropertyFileElement each : this.getElements()) {
            if (each.isDeleted()) continue;
            result.addln(each.getRepresentation());
        }
        this.dropDeletedElements();
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<PropertyFileElement> list = this.elementList;
        synchronized (list) {
            this.elementList.clear();
        }
    }
}

