/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.properties.fileLevel;

import com.schneide.base.io.encoding.Encoding;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.properties.fileLevel.ActiveElement;
import com.schneide.base.properties.fileLevel.DirtyFlag;
import com.schneide.base.properties.fileLevel.InactiveElement;
import com.schneide.base.properties.fileLevel.PropertyEntry;
import com.schneide.base.properties.fileLevel.PropertyFileElement;
import com.schneide.base.properties.fileLevel.PropertyFileElementHolder;
import com.schneide.base.properties.fileLevel.PropertyFileParser;
import com.schneide.base.properties.fileLevel.PropertySection;
import com.schneide.base.text.TextBuffer;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;

public class PropertyFile
extends LoggedObject {
    private final VirtualFile sourceFile;
    private final Charset encoding;
    private final Object reloadLock;
    private final PropertyFileElementHolder elements;
    private final DirtyFlag dirty;

    public PropertyFile(VirtualFile sourceFile, Object reloadLock) {
        this.reloadLock = reloadLock;
        this.encoding = Encoding.utf8();
        this.sourceFile = sourceFile;
        this.elements = new PropertyFileElementHolder();
        this.dirty = DirtyFlag.of(sourceFile);
        this.reload();
    }

    public VirtualFile getSourceFile() {
        return this.sourceFile;
    }

    public String name() {
        return this.sourceFile.getName();
    }

    public boolean needsReload() {
        return this.dirty.isDirty();
    }

    public void setAsReloaded() {
        this.dirty.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        Object object = this.reloadLock;
        synchronized (object) {
            if (!this.dirty.isDirty()) {
                return;
            }
            this.elements.clear();
            if (this.sourceFile.exists() && this.sourceFile.canRead()) {
                try {
                    if (this.sourceFile.getSize() == 0L) {
                        this.getLogger().warn("Die Einstellungsdatei " + this.sourceFile.getName() + " hat keinen Inhalt.");
                    }
                    PropertyFileElementHolder loaded = new PropertyFileParser(this.encoding).parseContentOf(this.sourceFile);
                    this.elements.addAllFrom(loaded);
                }
                catch (IOException e) {
                    this.getLogger().error("Could not read configuration file.", e);
                }
            }
            this.dirty.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<PropertyFileElement> getElements() {
        Object object = this.reloadLock;
        synchronized (object) {
            return this.elements.getElements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyEntry addPropertyElement(String key, String value) {
        Object object = this.reloadLock;
        synchronized (object) {
            PropertyEntry result = new PropertyEntry(key, value);
            this.addActiveElement(result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActiveElement(ActiveElement element) {
        Object object = this.reloadLock;
        synchronized (object) {
            this.elements.addElement(element);
            this.dirty.reportModification();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPassiveElement(InactiveElement element) {
        Object object = this.reloadLock;
        synchronized (object) {
            this.elements.addElement(element);
            this.dirty.reportModification();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<PropertySection> getPropertySections() {
        Object object = this.reloadLock;
        synchronized (object) {
            ArrayList<PropertySection> resultList = new ArrayList<PropertySection>();
            PropertySection nullSection = new PropertySection("");
            for (PropertyFileElement element : this.elements.getElements()) {
                if (element instanceof PropertySection) {
                    resultList.add((PropertySection)element);
                    continue;
                }
                nullSection.addElement(element);
            }
            resultList.add(0, nullSection);
            return resultList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.reloadLock;
        synchronized (object) {
            TextBuffer result = new TextBuffer();
            result.add(this.getLocation());
            result.addln(":");
            result.add(this.elements.toString());
            return result.toString();
        }
    }

    public String getLocation() {
        return this.sourceFile.getAbsoluteName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        Object object = this.reloadLock;
        synchronized (object) {
            this.sourceFile.getParent().createAsDirectory();
            try (OutputStreamWriter output = new OutputStreamWriter(this.sourceFile.getOutputStream(), this.encoding);
                 PrintWriter writer = new PrintWriter(new BufferedWriter(output));){
                writer.write(this.elements.toString());
            }
            this.dirty.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws IOException {
        Object object = this.reloadLock;
        synchronized (object) {
            StringBuffer newNameBuffer = new StringBuffer();
            newNameBuffer.append(this.sourceFile.getAbsoluteName());
            newNameBuffer.append(".deleted");
            this.sourceFile.renameTo(newNameBuffer.toString());
            this.dirty.reportModification();
        }
    }

    public void removeElements(PropertyFileElement ... removedElements) {
        this.removeElements(Arrays.asList(removedElements));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElements(Iterable<PropertyFileElement> removedElements) {
        Object object = this.reloadLock;
        synchronized (object) {
            for (PropertyFileElement element : removedElements) {
                this.elements.removeElement(element);
            }
            this.dirty.reportModification();
        }
    }
}

