/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.properties.applicationLevel;

import com.schneide.base.properties.ConfigurationPart;
import com.schneide.base.properties.applicationLevel.InterpretedMultiProperty;
import com.schneide.base.properties.applicationLevel.InterpretedProperty;
import com.schneide.base.properties.applicationLevel.PropertyReferenceType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class StringsProperty
extends InterpretedMultiProperty {
    private List<String> values;

    private static void setDefaultValue(StringsProperty property, String[] defaultValue) {
        if (InterpretedProperty.hasDefaultValue(defaultValue)) {
            property.values.clear();
            Collections.addAll(property.values, defaultValue);
        }
    }

    public static StringsProperty buildUnbound(PropertyReferenceType reference) {
        return StringsProperty.buildUnbound(reference, (String[])null);
    }

    public static StringsProperty buildUnbound(PropertyReferenceType reference, String defaultValue) {
        return StringsProperty.buildUnbound(reference, new String[]{defaultValue});
    }

    public static StringsProperty buildUnbound(PropertyReferenceType reference, String[] defaultValue) {
        return new StringsProperty(reference, defaultValue);
    }

    protected StringsProperty(PropertyReferenceType reference, String[] defaultValue) {
        super(reference, InterpretedProperty.hasDefaultValue(defaultValue));
        if (!this.isBound()) {
            StringsProperty.setDefaultValue(this, defaultValue);
        }
    }

    public static StringsProperty buildConfigured(ConfigurationPart configuration, PropertyReferenceType reference) {
        return StringsProperty.buildConfigured(configuration, reference, (String[])null);
    }

    public static StringsProperty buildConfigured(ConfigurationPart configuration, PropertyReferenceType reference, String defaultValue) {
        return StringsProperty.buildConfigured(configuration, reference, new String[]{defaultValue});
    }

    public static StringsProperty buildConfigured(ConfigurationPart configuration, PropertyReferenceType reference, String[] defaultValue) {
        return new StringsProperty(configuration, reference, defaultValue);
    }

    protected StringsProperty(ConfigurationPart configuration, PropertyReferenceType reference, String[] defaultValue) {
        super(configuration, reference, InterpretedProperty.hasDefaultValue(defaultValue));
        StringsProperty.setDefaultValue(this, defaultValue);
    }

    @Override
    protected void convertToValues(String[] stringValues) {
        if (null == this.values) {
            this.values = new ArrayList<String>();
        }
        this.values.clear();
        Collections.addAll(this.values, stringValues);
    }

    @Override
    protected String[] convertValuesToStrings() {
        return this.getValues();
    }

    public Iterable<String> values() {
        return List.copyOf(this.values);
    }

    public String[] getValues() {
        if (null == this.values) {
            return new String[0];
        }
        return this.values.toArray(new String[this.values.size()]);
    }

    public void setValues(String[] values) {
        this.convertToValues(values);
        this.notifyChange();
    }

    @Override
    public Object getGenericValue() {
        return this.getValues();
    }
}

