/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.properties.applicationLevel;

import com.schneide.base.properties.ConfigurationPart;
import com.schneide.base.properties.applicationLevel.InterpretedProperty;
import com.schneide.base.properties.applicationLevel.InterpretedSingleProperty;
import com.schneide.base.properties.applicationLevel.PropertyReferenceType;

public class IntegerProperty
extends InterpretedSingleProperty {
    private int value;

    private static void setDefaultValue(IntegerProperty property, Integer defaultValue) {
        if (InterpretedProperty.hasDefaultValue(defaultValue)) {
            property.value = defaultValue;
        }
    }

    public static IntegerProperty buildUnbound(PropertyReferenceType reference) {
        return IntegerProperty.buildUnbound(reference, null);
    }

    public static IntegerProperty buildUnbound(PropertyReferenceType reference, Integer defaultValue) {
        return new IntegerProperty(reference, defaultValue);
    }

    protected IntegerProperty(PropertyReferenceType reference, Integer defaultValue) {
        super(reference, InterpretedProperty.hasDefaultValue(defaultValue));
        IntegerProperty.setDefaultValue(this, defaultValue);
    }

    public static IntegerProperty buildConfigured(ConfigurationPart configuration, PropertyReferenceType reference) {
        return IntegerProperty.buildConfigured(configuration, reference, null);
    }

    public static IntegerProperty buildConfigured(ConfigurationPart configuration, PropertyReferenceType reference, Integer defaultValue) {
        return new IntegerProperty(configuration, reference, defaultValue);
    }

    protected IntegerProperty(ConfigurationPart configuration, PropertyReferenceType reference, Integer defaultValue) {
        super(configuration, reference, InterpretedProperty.hasDefaultValue(defaultValue));
        if (!this.isBound()) {
            IntegerProperty.setDefaultValue(this, defaultValue);
        }
    }

    @Override
    protected void convertToValue(String stringValue) {
        if (null == stringValue) {
            this.getLogger().warn("Won't parse null value for " + this.getKey());
            return;
        }
        try {
            this.value = Integer.parseInt(stringValue);
        }
        catch (NumberFormatException e) {
            this.getLogger().error("Could not parse the input to an integer: " + stringValue, e);
        }
    }

    @Override
    protected String convertValueToString() {
        return Integer.toString(this.value);
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
        this.notifyChange();
    }

    @Override
    public Object getGenericValue() {
        return this.getValue();
    }
}

