/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.properties.applicationLevel;

import com.schneide.base.io.file.FileUtil;
import com.schneide.base.properties.ConfigurationPart;
import com.schneide.base.properties.applicationLevel.InterpretedProperty;
import com.schneide.base.properties.applicationLevel.InterpretedSingleProperty;
import com.schneide.base.properties.applicationLevel.PropertyReferenceType;
import java.io.File;
import java.io.IOException;

public class FileProperty
extends InterpretedSingleProperty {
    private File value;

    private static void setDefaultValue(FileProperty property, File defaultValue) {
        if (InterpretedProperty.hasDefaultValue(defaultValue)) {
            property.value = defaultValue;
        }
    }

    public static FileProperty buildUnbound(PropertyReferenceType reference) {
        return FileProperty.buildUnbound(reference, null);
    }

    public static FileProperty buildUnbound(PropertyReferenceType reference, File defaultValue) {
        return new FileProperty(reference, defaultValue);
    }

    protected FileProperty(PropertyReferenceType reference, File defaultValue) {
        super(reference, InterpretedProperty.hasDefaultValue(defaultValue));
        FileProperty.setDefaultValue(this, defaultValue);
    }

    public static FileProperty buildConfigured(ConfigurationPart configuration, PropertyReferenceType reference) {
        return FileProperty.buildConfigured(configuration, reference, null);
    }

    public static FileProperty buildConfigured(ConfigurationPart configuration, PropertyReferenceType reference, File defaultValue) {
        return new FileProperty(configuration, reference, defaultValue);
    }

    protected FileProperty(ConfigurationPart part, PropertyReferenceType reference, File defaultValue) {
        super(part, reference, InterpretedProperty.hasDefaultValue(defaultValue));
        if (!this.isBound()) {
            FileProperty.setDefaultValue(this, defaultValue);
        }
    }

    @Override
    protected void convertToValue(String stringValue) {
        this.value = new File(stringValue.replace('/', File.separatorChar));
    }

    @Override
    protected String convertValueToString() {
        return this.value.getPath();
    }

    public File getValue() {
        return this.value;
    }

    public File handleValue() {
        if (!this.value.exists()) {
            FileUtil.ensureSuccessWithWarning("Error while creating dir", this.value.getParentFile().mkdirs());
            this.handleCreation(this.value);
        }
        return this.value;
    }

    protected boolean handleCreation(File file) {
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            this.getLogger().warn("Problem creating file " + String.valueOf(file), e);
            return false;
        }
    }

    public void setValue(File newValue) {
        this.value = newValue;
        this.notifyChange();
    }

    @Override
    public Object getGenericValue() {
        return this.getValue();
    }
}

