/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.properties.applicationLevel;

import com.schneide.base.properties.ConfigurationPart;
import com.schneide.base.properties.applicationLevel.InterpretedProperty;
import com.schneide.base.properties.applicationLevel.InterpretedSingleProperty;
import com.schneide.base.properties.applicationLevel.PropertyReferenceType;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public class DoubleProperty
extends InterpretedSingleProperty {
    private double value;

    private static void setDefaultValue(DoubleProperty property, Double defaultValue) {
        if (InterpretedProperty.hasDefaultValue(defaultValue)) {
            property.value = defaultValue;
        }
    }

    public static DoubleProperty buildUnbound(PropertyReferenceType reference) {
        return DoubleProperty.buildUnbound(reference, null);
    }

    public static DoubleProperty buildUnbound(PropertyReferenceType reference, Double defaultValue) {
        return new DoubleProperty(reference, defaultValue);
    }

    protected DoubleProperty(PropertyReferenceType reference, Double defaultValue) {
        super(reference, InterpretedProperty.hasDefaultValue(defaultValue));
        DoubleProperty.setDefaultValue(this, defaultValue);
    }

    public static DoubleProperty buildConfigured(ConfigurationPart configuration, PropertyReferenceType reference) {
        return DoubleProperty.buildConfigured(configuration, reference, null);
    }

    public static DoubleProperty buildConfigured(ConfigurationPart configuration, PropertyReferenceType reference, Double defaultValue) {
        return new DoubleProperty(configuration, reference, defaultValue);
    }

    protected DoubleProperty(ConfigurationPart configuration, PropertyReferenceType reference, Double defaultValue) {
        super(configuration, reference, InterpretedProperty.hasDefaultValue(defaultValue));
        if (!this.isBound()) {
            DoubleProperty.setDefaultValue(this, defaultValue);
        }
    }

    @Override
    protected void convertToValue(String stringValue) {
        try {
            this.value = DoubleProperty.convert(stringValue);
        }
        catch (ParseException pe) {
            this.getLogger().error("Could not parse the input to a double: " + stringValue, pe);
        }
    }

    public static double convert(String text) throws ParseException {
        try {
            return Double.parseDouble(text);
        }
        catch (NumberFormatException e) {
            NumberFormat format = NumberFormat.getInstance(Locale.GERMAN);
            return format.parse(text).doubleValue();
        }
    }

    @Override
    protected String convertValueToString() {
        return Double.toString(this.value);
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public Object getGenericValue() {
        return this.getValue();
    }

    public void setValue(double value) {
        this.value = value;
        this.notifyChange();
    }
}

