/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.properties.applicationLevel;

public class BooleanSyntax {
    public static final BooleanSyntax[] DEFAULT = new BooleanSyntax[]{new BooleanSyntax("true", "false"), new BooleanSyntax("ja", "nein"), new BooleanSyntax("yes", "no"), new BooleanSyntax("1", "0"), new BooleanSyntax("enabled", "disabled"), new BooleanSyntax("on", "off")};
    private final String positiveValue;
    private final String negativeValue;

    public BooleanSyntax(String positiveValue, String negativeValue) {
        this.positiveValue = positiveValue;
        this.negativeValue = negativeValue;
    }

    public String getNegativeValue() {
        return this.negativeValue;
    }

    public String getPositiveValue() {
        return this.positiveValue;
    }

    public String getValueOf(boolean value) {
        if (value) {
            return this.getPositiveValue();
        }
        return this.getNegativeValue();
    }

    public boolean isPositiveValue(String value) {
        return this.compareValues(this.getPositiveValue(), value);
    }

    public boolean isNegativeValue(String value) {
        return this.compareValues(this.getNegativeValue(), value);
    }

    protected boolean compareValues(String internal, String external) {
        return internal.equalsIgnoreCase(external);
    }
}

