/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.properties;

import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.io.virtual.string.StringVirtualFile;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.properties.ConfigurationPart;
import com.schneide.base.properties.ConfigurationSection;
import com.schneide.base.properties.Property;
import com.schneide.base.properties.PropertyValueListener;
import com.schneide.base.properties.SectionHolder;
import com.schneide.base.properties.applicationLevel.PropertyReferenceType;
import com.schneide.base.properties.fileLevel.PropertyFile;
import com.schneide.base.properties.fileLevel.PropertySection;
import com.schneide.base.properties.fileLevel.Whitespace;
import com.schneide.base.text.buffer.DirectChunkBuffer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;

public class Configuration
extends LoggedObject
implements PropertyValueListener,
ConfigurationPart {
    public static final String defaultSection = "";
    private final List<PropertyFile> files;
    private final SectionHolder sectionHolder;
    private final Object reloadLock = new Object();

    public static Configuration empty() {
        return new Configuration(StringVirtualFile.createFileFromContent("empty", defaultSection));
    }

    public Configuration(VirtualFile ... propertyFiles) {
        this(List.of(propertyFiles));
    }

    public Configuration(Iterable<VirtualFile> sourceFiles) {
        Iterable<Function<Object, PropertyFile>> fileProviders = Configuration.createPropertyFilesFrom(sourceFiles);
        if (IterableUtil.isEmpty(fileProviders)) {
            this.getLogger().warn("Creating a configuration instance without property file backing. You won't be able to save anything.");
        }
        ArrayList<PropertyFile> propertyFiles = new ArrayList<PropertyFile>();
        for (Function<Object, PropertyFile> each : fileProviders) {
            propertyFiles.add(each.apply(this.reloadLock));
        }
        this.files = propertyFiles;
        this.sectionHolder = new SectionHolder(this.reloadLock);
        this.reload(true);
    }

    private static Iterable<Function<Object, PropertyFile>> createPropertyFilesFrom(Iterable<VirtualFile> propertyFiles) {
        ArrayList<Function<Object, PropertyFile>> result = new ArrayList<Function<Object, PropertyFile>>();
        for (VirtualFile file : propertyFiles) {
            result.add(lock -> new PropertyFile(file, lock));
        }
        return result;
    }

    public void reload() {
        this.reload(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reload(boolean forced) {
        Object object = this.reloadLock;
        synchronized (object) {
            boolean needsReload;
            if (!forced && !(needsReload = this.files.stream().anyMatch(PropertyFile::needsReload))) {
                return;
            }
            this.reloadFromFiles();
        }
    }

    protected void reloadFromFiles() {
        this.removeAllSections();
        for (PropertyFile each : this.files) {
            each.reload();
            for (PropertySection element : each.getPropertySections()) {
                ConfigurationSection section = new ConfigurationSection(each, element, this);
                this.sectionHolder.mergeSection(section);
            }
        }
        this.files.forEach(PropertyFile::setAsReloaded);
    }

    public void release() {
        Property[] properties;
        for (Property element : properties = this.getAllProperties()) {
            element.removePropertyValueListener(this);
        }
    }

    @Override
    public Configuration getConfiguration() {
        return this;
    }

    @Override
    public String getPartIdentifier() {
        return defaultSection;
    }

    @Override
    public void propertyValueChanged(Property property) {
        this.commit();
    }

    @Override
    public boolean hasProperty(String key) {
        return this.hasProperty(defaultSection, key);
    }

    public void setProperty(String key, Object stringValue) {
        this.setPropertyValue(key, stringValue);
    }

    public void setPropertyValue(String key, Object stringValue) {
        String value = String.valueOf(stringValue);
        if (!this.hasProperty(key)) {
            this.addProperty(key, value);
        }
        this.getLogger().debug("Setting property value " + key + " to " + value);
        this.getProperty(key).setValue(value);
    }

    public boolean hasProperty(String section, String key) {
        Object object = this.reloadLock;
        synchronized (object) {
            try {
                return this.getSection(section).hasProperty(key);
            }
            catch (NoSuchElementException e) {
                this.getLogger().warn("Didnt find section for key " + key + " in " + this.getClass().getSimpleName());
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Property getProperty(String section, String key) throws NoSuchElementException {
        Object object = this.reloadLock;
        synchronized (object) {
            return this.getSection(section).getProperty(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Property retrieveProperty(String section, String key, String defaultValue) {
        Object object = this.reloadLock;
        synchronized (object) {
            if (!this.hasProperty(section, key)) {
                this.addProperty(section, key, defaultValue);
            }
            return this.getProperty(section, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProperty(String section, String key, String value) {
        Object object = this.reloadLock;
        synchronized (object) {
            this.getSection(section).addProperty(key, value);
        }
    }

    public void addProperty(String key, String value) {
        this.addProperty(defaultSection, key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Property> propertyFor(String key) {
        Object object = this.reloadLock;
        synchronized (object) {
            return this.getSection(defaultSection).propertyFor(key);
        }
    }

    @Override
    public Property getProperty(String key) throws NoSuchElementException {
        return this.getProperty(defaultSection, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationSection getSection(String section) throws NoSuchElementException {
        Object object = this.reloadLock;
        synchronized (object) {
            return this.sectionHolder.getSection(section);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<ConfigurationSection> getSections() {
        Object object = this.reloadLock;
        synchronized (object) {
            return this.sectionHolder.getSections();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<ConfigurationSection> sectionFor(String key) {
        Object object = this.reloadLock;
        synchronized (object) {
            return this.sectionHolder.section(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationSection createOrRetrieveSectionFor(String type, String key) {
        Object object = this.reloadLock;
        synchronized (object) {
            return this.sectionFor(type, key).orElseGet(() -> this.addSection(type, key));
        }
    }

    public Optional<ConfigurationSection> sectionFor(String type, String key) {
        for (ConfigurationSection element : this.sections(type)) {
            if (!key.equals(element.getIdentifier())) continue;
            return Optional.of(element);
        }
        return Optional.empty();
    }

    public ConfigurationSection getSection(String type, String key) throws NoSuchElementException {
        return this.sectionFor(type, key).orElseThrow(() -> new NoSuchElementException("No section found with type " + type + " and key " + key + "."));
    }

    public boolean hasSection(String type, String key) {
        for (ConfigurationSection element : this.sections(type)) {
            if (!key.equals(element.getIdentifier())) continue;
            return true;
        }
        return false;
    }

    public ConfigurationSection defaultSection() {
        return this.getSection(defaultSection, defaultSection);
    }

    public ConfigurationSection[] getSections(String sectionType) {
        return IterableUtil.toArray(ConfigurationSection.class, this.sections(sectionType));
    }

    public Iterable<ConfigurationSection> sections(String sectionType) {
        ArrayList<ConfigurationSection> resultList = new ArrayList<ConfigurationSection>();
        for (ConfigurationSection element : this.getSections()) {
            if (!sectionType.equals(element.getType())) continue;
            resultList.add(element);
        }
        return resultList;
    }

    public Property[] getProperties() {
        return this.getProperties(defaultSection);
    }

    public Iterable<Property> properties() {
        return this.properties(defaultSection);
    }

    public Property[] getProperties(String section) {
        return this.getProperties(new String[]{section});
    }

    public Property[] getProperties(String[] sections) {
        ArrayList<Property> result = new ArrayList<Property>();
        for (String element : sections) {
            ConfigurationSection section = this.getSection(element);
            result.addAll(Arrays.asList(section.getProperties()));
        }
        return result.toArray(new Property[result.size()]);
    }

    public Iterable<Property> properties(String section) {
        return this.properties(List.of(section));
    }

    public Iterable<Property> properties(Iterable<String> sections) {
        ArrayList<Property> result = new ArrayList<Property>();
        for (String element : sections) {
            ConfigurationSection section = this.getSection(element);
            result.addAll(Arrays.asList(section.getProperties()));
        }
        return result;
    }

    public Property[] getAllProperties() {
        return this.getProperties(this.getSectionIdentifiers());
    }

    public String[] getSectionIdentifiers() {
        ArrayList<String> result = new ArrayList<String>();
        for (ConfigurationSection each : this.getSections()) {
            result.add(each.getIdentifier());
        }
        return result.toArray(new String[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        Object object = this.reloadLock;
        synchronized (object) {
            for (PropertyFile element : this.files) {
                try {
                    element.save();
                }
                catch (IOException e) {
                    this.getLogger().error("Error while saving a configuration element " + String.valueOf(element), e);
                }
            }
        }
    }

    public Iterable<VirtualFile> getOriginalFiles() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (PropertyFile propertyFile : this.files) {
            result.add(propertyFile.getSourceFile());
        }
        return result;
    }

    public Iterable<PropertyFile> getPropertyFiles() {
        return this.files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationSection addSection(String type, String identifier) {
        Object object = this.reloadLock;
        synchronized (object) {
            ConfigurationSection result = new ConfigurationSection(this, type, identifier, IterableUtil.firstOf(this.getPropertyFiles()));
            this.addSectionElementToFiles(result);
            this.sectionHolder.addSection(result);
            return result;
        }
    }

    protected void addSectionElementToFiles(ConfigurationSection section) {
        PropertyFile firstFile = IterableUtil.firstOf(this.getPropertyFiles());
        firstFile.addPassiveElement(new Whitespace(defaultSection));
        firstFile.addActiveElement(section.getPropertySection());
    }

    @Override
    public PropertyReferenceType resolveRelativeReference(PropertyReferenceType reference) {
        return reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSection(ConfigurationSection section) {
        if (null == section) {
            return;
        }
        Object object = this.reloadLock;
        synchronized (object) {
            this.sectionHolder.removeSection(section);
            Property[] properties = section.getProperties();
            for (Property property : properties) {
                property.deleteAll();
            }
            for (PropertyFile file : this.files) {
                file.removeElements(section.getPropertySection());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllSections() {
        Object object = this.reloadLock;
        synchronized (object) {
            for (ConfigurationSection section : this.getSections()) {
                this.removeSection(section);
            }
        }
    }

    public String filenames() {
        DirectChunkBuffer result = new DirectChunkBuffer(", ");
        for (PropertyFile each : this.getPropertyFiles()) {
            result.add(each.getLocation());
        }
        return result.toString();
    }

    public String toString() {
        return this.filenames();
    }

    public String getPropertyValue(String key) {
        return this.getProperty(key).getValue();
    }
}

