/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.network;

import com.schneide.base.io.encoding.Encoding;
import com.schneide.base.logging.LoggedObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.UnknownHostException;

public abstract class Ping
extends LoggedObject {
    private final String address;

    public Ping(String address) {
        this.address = address;
    }

    public boolean perform() {
        try {
            return this.checkViaOperatingSystem();
        }
        catch (UnknownHostException e) {
            this.getLogger().debug(this.address() + " could not be reached", e);
            return false;
        }
        catch (IOException e) {
            this.getLogger().debug(this.address() + " could not be reached", e);
            return false;
        }
    }

    private boolean checkViaOperatingSystem() throws IOException {
        Process execProcess = this.executePingCommand();
        try (BufferedReader reader = this.buildReaderFrom(execProcess);){
            StringBuffer result = this.gatherResult(reader);
            boolean bl = this.determineReachabilityFrom(result);
            return bl;
        }
    }

    private StringBuffer gatherResult(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        StringBuffer result = new StringBuffer();
        while (line != null) {
            result.append(line);
            line = reader.readLine();
        }
        return result;
    }

    private BufferedReader buildReaderFrom(Process execProcess) {
        return new BufferedReader(new InputStreamReader(execProcess.getInputStream(), Encoding.isoLatin1()));
    }

    private Process executePingCommand() throws IOException {
        Runtime runtime = Runtime.getRuntime();
        Process execProcess = runtime.exec(this.pingCommandString());
        return execProcess;
    }

    protected String address() {
        return this.address;
    }

    protected abstract String pingCommandString();

    protected abstract boolean determineReachabilityFrom(StringBuffer var1);
}

