/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.maths;

import java.text.DecimalFormat;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;

public class Percent {
    public static final String einheit = "%";
    public static final Percent zero = Percent.fromFactor(0.0);
    public static final Percent oneHundred = Percent.fromFactor(1.0);
    public static final double percentageFactor = 100.0;
    private final double value;

    public Percent(double value) {
        this.value = value;
    }

    public double getValue() {
        return this.value;
    }

    public double getAsFactor() {
        return this.getValue() / 100.0;
    }

    public static Percent fromFactor(double factor) {
        return new Percent(factor * 100.0);
    }

    public static Percent createFromFactor(long part, long whole) {
        return Percent.fromFactor((double)part / (double)whole);
    }

    public Percent inverted() {
        return new Percent(100.0 - this.getValue());
    }

    public Percent asDeviation() {
        return new Percent(this.getValue() - 100.0);
    }

    public String toFormattedString(DecimalFormat format) {
        StringBuilder result = new StringBuilder();
        if (format != null) {
            result.append(format.format(this.getValue()));
        } else {
            result.append(this.getValue());
        }
        result.append(this.einheitAlsZusatz());
        return result.toString();
    }

    public String toDefaultFormattedString() {
        return this.toFormattedString(null);
    }

    public String formattedWith(Function<Number, String> format) {
        return format.apply(this.getValue()) + this.einheitAlsZusatz();
    }

    private String einheitAlsZusatz() {
        return " %";
    }

    public Percent plus(Percent other) {
        return new Percent(this.value + other.value);
    }

    public Percent minus(Percent other) {
        return new Percent(this.value - other.value);
    }

    public boolean greaterThan(Percent comparedValue) {
        return this.value > comparedValue.value;
    }

    public boolean lessThan(Percent comparedValue) {
        return this.value < comparedValue.value;
    }

    public boolean becomesTrue() {
        return this.becomesTrueWith(new Random());
    }

    public boolean becomesTrueWith(Random random) {
        return this.getAsFactor() > random.nextDouble();
    }

    public double multiplyWith(double otherValue) {
        return this.getAsFactor() * otherValue;
    }

    public Percent divideBy(double quotient) {
        return new Percent(this.value / quotient);
    }

    public boolean isOneHundred() {
        return this.equals(oneHundred);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Percent other = (Percent)obj;
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other.value);
    }

    public String toString() {
        return this.toDefaultFormattedString();
    }

    public Percent absolut() {
        return new Percent(Math.abs(this.value));
    }
}

