/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.maths;

import com.schneide.base.maths.AbstractIterativeDoubleCalculator;
import java.util.Optional;

public class IterativeDoubleMaximumCalculator
extends AbstractIterativeDoubleCalculator {
    private final double resetValue;
    private double maximumValue;

    public IterativeDoubleMaximumCalculator() {
        this(-1.7976931348623157E308);
    }

    public IterativeDoubleMaximumCalculator(double resetValue) {
        this.resetValue = resetValue;
        this.maximumValue = resetValue;
    }

    @Override
    protected void internalAddValue(double value) {
        this.maximumValue = Math.max(this.maximumValue, value);
    }

    @Override
    protected void internalReset() {
        this.maximumValue = this.resetValue;
    }

    public double getMaximumValue() {
        return this.performSynchronized(() -> {
            if (this.getValueCount() == 0) {
                return Double.NaN;
            }
            return this.maximumValue;
        });
    }

    public Optional<Double> maximumValueIfCalculated() {
        if (!this.hasValues()) {
            return Optional.empty();
        }
        return Optional.of(this.getMaximumValue());
    }
}

