/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.maths;

import com.schneide.base.i18n.I18NObject;
import com.schneide.base.maths.AbstractIterativeDoubleCalculator;
import com.schneide.base.maths.AbstractIterativeDoubleMeanCalculator;
import com.schneide.base.maths.CalculatorListener;
import com.schneide.base.maths.IterativeDoubleMaximumCalculator;
import com.schneide.base.maths.IterativeDoubleMeanCalculator;
import com.schneide.base.maths.IterativeDoubleMinimumCalculator;
import java.util.ArrayList;
import java.util.List;

public class IterativeCalculator
extends I18NObject {
    private final String denotation;
    private int valueCount;
    private final AbstractIterativeDoubleMeanCalculator meanValue;
    private final IterativeDoubleMaximumCalculator maximumValue;
    private final IterativeDoubleMinimumCalculator minimumValue;
    private final List<CalculatorListener> calculatorListenerList;

    public IterativeCalculator() {
        this("");
    }

    public IterativeCalculator(String denotation) {
        this(denotation, new IterativeDoubleMeanCalculator());
    }

    public IterativeCalculator(String denotation, AbstractIterativeDoubleMeanCalculator meanValueCalculator) {
        this.denotation = denotation;
        this.calculatorListenerList = new ArrayList<CalculatorListener>();
        this.meanValue = meanValueCalculator;
        this.valueCount = 0;
        this.maximumValue = new IterativeDoubleMaximumCalculator();
        this.minimumValue = new IterativeDoubleMinimumCalculator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCalculatorListener(CalculatorListener listener) {
        if (listener != null) {
            List<CalculatorListener> list = this.calculatorListenerList;
            synchronized (list) {
                this.calculatorListenerList.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCalculatorListener(CalculatorListener listener) {
        if (listener != null) {
            List<CalculatorListener> list = this.calculatorListenerList;
            synchronized (list) {
                this.calculatorListenerList.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyNewCalculations() {
        List<CalculatorListener> list = this.calculatorListenerList;
        synchronized (list) {
            for (CalculatorListener calculatorListener : this.calculatorListenerList) {
                calculatorListener.newCalculations(this);
            }
        }
    }

    public String getDenotation() {
        return this.denotation;
    }

    public void addValue(double value) {
        if (AbstractIterativeDoubleCalculator.isValidValue(value)) {
            ++this.valueCount;
            this.meanValue.addValue(value);
            this.maximumValue.addValue(value);
            this.minimumValue.addValue(value);
            this.notifyNewCalculations();
        }
    }

    public final double getMeanValue() {
        return this.meanValue.getMeanValue();
    }

    public final double getMaximumValue() {
        return this.maximumValue.getMaximumValue();
    }

    public final double getMinimumValue() {
        return this.minimumValue.getMinimumValue();
    }

    public final int getValueCount() {
        return this.valueCount;
    }

    public String toString() {
        return this.getI18N().getParametrizedText("IterativeCalculator.toString", this.getDenotation(), this.getMinimumValue(), this.getMeanValue(), this.getMaximumValue());
    }
}

