/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.maths;

import java.util.function.Supplier;

public abstract class AbstractIterativeDoubleCalculator {
    private final Object threadLock = new Object();
    private int valueCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addValue(double value) {
        Object object = this.threadLock;
        synchronized (object) {
            if (AbstractIterativeDoubleCalculator.isValidValue(value)) {
                ++this.valueCount;
                this.internalAddValue(value);
            }
        }
    }

    protected abstract void internalAddValue(double var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset() {
        Object object = this.threadLock;
        synchronized (object) {
            this.valueCount = 0;
            this.internalReset();
        }
    }

    protected abstract void internalReset();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getValueCount() {
        Object object = this.threadLock;
        synchronized (object) {
            return this.valueCount;
        }
    }

    public final boolean hasValues() {
        return this.getValueCount() > 0;
    }

    public static boolean isValidValue(double value) {
        return !Double.isNaN(value) && !Double.isInfinite(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T performSynchronized(Supplier<T> operation) {
        Object object = this.threadLock;
        synchronized (object) {
            return operation.get();
        }
    }
}

