/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.logging.implementation.file;

import com.schneide.base.io.encoding.Encoding;
import com.schneide.base.io.tools.IOCloser;
import com.schneide.base.logging.implementation.DefaultLoggerBase;
import com.schneide.base.text.transformation.Embrace;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.time.LocalDateTime;

public class SingleFileLogger
extends DefaultLoggerBase {
    private final PrintStream output;

    public SingleFileLogger(File targetFile) {
        this.output = this.streamOf(targetFile);
    }

    private PrintStream streamOf(File targetFile) {
        try {
            final PrintStream result = new PrintStream(targetFile, Encoding.utf8().name());
            Runtime.getRuntime().addShutdownHook(new Thread(this){

                @Override
                public void run() {
                    IOCloser.close(result);
                }
            });
            return result;
        }
        catch (IOException e) {
            return System.out;
        }
    }

    protected PrintStream file() {
        return this.output;
    }

    @Override
    protected void logException(Throwable t) {
        this.logExceptionTo(this.file(), t);
    }

    @Override
    protected void logObject(DefaultLoggerBase.LogLevel logLevel, Object o) {
        this.logObjectTo(this.file(), logLevel, o);
    }

    protected void logExceptionTo(PrintStream printer, Throwable t) {
        t.printStackTrace(printer);
    }

    protected void logObjectTo(PrintStream printer, DefaultLoggerBase.LogLevel logLevel, Object o) {
        printer.print(LocalDateTime.now());
        printer.print(" ");
        printer.print(Embrace.withSquareBrackets(Thread.currentThread().getName()));
        printer.print(" ");
        printer.print(logLevel.name());
        printer.print(": ");
        printer.print(o);
        printer.println();
        printer.flush();
    }
}

