/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.logging.implementation;

import com.schneide.base.logging.Logger;
import com.schneide.base.logging.LoggerFactory;
import com.schneide.base.logging.LoggingConfigurator;
import com.schneide.base.logging.implementation.Log4jSchneideLogger;
import com.schneide.base.logging.implementation.console.ConsoleLoggerFactory;
import java.net.URL;

public class SchneideLoggerFactory
implements LoggerFactory {
    private LoggerFactory replacementFactory;

    public SchneideLoggerFactory() {
        URL loggingConfigFile = Thread.currentThread().getContextClassLoader().getResource(LoggingConfigurator.getConfigFile());
        if (loggingConfigFile == null) {
            this.replacementFactory = new ConsoleLoggerFactory();
        }
    }

    @Override
    public Logger getLogger(String id) {
        if (this.replacementFactory != null) {
            return this.replacementFactory.getLogger(id);
        }
        return Log4jSchneideLogger.getLogger(id);
    }
}

