/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.logging.implementation;

import com.schneide.base.io.file.Directory;
import com.schneide.base.logging.LoggingConfigurator;
import com.schneide.base.logging.implementation.AbstractLogger;
import com.schneide.base.text.TextBuffer;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

public final class Log4jSchneideLogger
extends AbstractLogger {
    private static Map<String, Log4jSchneideLogger> instances = new HashMap<String, Log4jSchneideLogger>();
    private final Logger logger;

    private static void setupLoggingDirectory() {
        try {
            Directory.ensureForPath("logs");
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create logging directory.", e);
        }
    }

    private Logger getLogger() {
        return this.logger;
    }

    private Log4jSchneideLogger(String name) {
        this.logger = Logger.getLogger((String)name);
    }

    public static synchronized Log4jSchneideLogger getStaticLogger(Class<?> targetClass) {
        return Log4jSchneideLogger.getLogger(targetClass.getName());
    }

    public static synchronized Log4jSchneideLogger getLogger(Object o) {
        return Log4jSchneideLogger.getLogger(o.getClass().getName());
    }

    public static synchronized Log4jSchneideLogger getLogger(Class<?> targetClass) {
        return Log4jSchneideLogger.getStaticLogger(targetClass);
    }

    public static synchronized Log4jSchneideLogger getLogger(String name) {
        Log4jSchneideLogger logger = instances.get(name);
        if (logger == null) {
            logger = new Log4jSchneideLogger(name);
            instances.put(name, logger);
        }
        return logger;
    }

    @Override
    public void debug(Object o) {
        this.getLogger().debug(o);
    }

    @Override
    public void debug(Object o, Throwable t) {
        this.getLogger().debug(o, t);
    }

    @Override
    public void error(Object o) {
        this.getLogger().error(o);
    }

    @Override
    public void error(Object o, Throwable t) {
        this.getLogger().error(o, t);
    }

    @Override
    protected void performFatalLogging(Object o) {
        this.getLogger().fatal(o);
    }

    @Override
    protected void performFatalLogging(Object o, Throwable t) {
        this.getLogger().fatal(o, t);
        TextBuffer messageBuffer = new TextBuffer();
        messageBuffer.addln("A serious, not recoverable error occurred.");
        messageBuffer.addln();
        messageBuffer.addln("Error message:");
        messageBuffer.addln(o);
        JOptionPane.showMessageDialog(null, messageBuffer.toString(), "Fatal system error", 0);
    }

    @Override
    public void info(Object o) {
        this.getLogger().info(o);
    }

    @Override
    public void info(Object o, Throwable t) {
        this.getLogger().info(o, t);
    }

    @Override
    public void warn(Object o) {
        this.getLogger().warn(o);
    }

    @Override
    public void warn(Object o, Throwable t) {
        this.getLogger().warn(o, t);
    }

    static {
        Log4jSchneideLogger.setupLoggingDirectory();
        URL loggingConfigFile = Thread.currentThread().getContextClassLoader().getResource(LoggingConfigurator.getConfigFile());
        if (null != loggingConfigFile) {
            System.out.println("Konfiguration f\u00fcr Logging (URL): " + loggingConfigFile.getPath());
            DOMConfigurator.configure((URL)loggingConfigFile);
        }
    }
}

