/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.logging.filter;

import com.schneide.base.logging.filter.ClassnameFilter;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

public class ClassnameAndLoglevelFilter
extends Filter {
    private Level acceptFrom = Level.DEBUG;
    private final ClassnameFilter nameFilter = new ClassnameFilter();

    public int decide(LoggingEvent event) {
        int decisionBasedOnName = this.nameFilter.decide(event);
        if (1 == decisionBasedOnName && null != event.getLevel()) {
            if (event.getLevel().isGreaterOrEqual((Priority)this.acceptFrom)) {
                return 1;
            }
            return -1;
        }
        return decisionBasedOnName;
    }

    public void setAcceptFromLevel(String fromLevel) {
        this.acceptFrom = Level.toLevel((String)fromLevel);
    }

    public String getAcceptFromLevel() {
        return this.acceptFrom.toString();
    }

    public void setClassToMatch(String classToMatch) {
        this.nameFilter.setClassToMatch(classToMatch);
    }

    public String getClassToMatch() {
        return this.nameFilter.getClassToMatch();
    }

    public void setAcceptOnMatch(boolean acceptOnMatch) {
        this.nameFilter.setAcceptOnMatch(acceptOnMatch);
    }

    public boolean getAcceptOnMatch() {
        return this.nameFilter.getAcceptOnMatch();
    }
}

