/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.loader;

import com.schneide.base.loader.ModelSource;
import com.schneide.base.loader.TopicalityHandler;

public class GenericTopicalityHandler
implements TopicalityHandler {
    private final ModelSource source;
    private long lastModification;

    public GenericTopicalityHandler(ModelSource source) {
        this.source = source;
        this.resetTopicality();
    }

    @Override
    public final void resetTopicality() {
        this.lastModification = this.source.getLastModificationStamp();
    }

    @Override
    public final boolean hasChanged() {
        return this.lastModification < this.source.getLastModificationStamp();
    }

    public final boolean checkForChangeAndReset() {
        boolean result = this.hasChanged();
        this.resetTopicality();
        return result;
    }

    @Override
    public ModelSource getModelSource() {
        return this.source;
    }

    @Override
    public final void setChangedFlag() {
        this.lastModification = 0L;
    }
}

