/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.loader;

import com.schneide.base.loader.TopicalityHandler;
import com.schneide.base.logging.LoggedObject;
import java.io.IOException;

public abstract class AbstractModelHandler
extends LoggedObject {
    private final TopicalityHandler topicalityHandler;
    private final boolean canSave;
    private Object model;

    public AbstractModelHandler(TopicalityHandler topicalityHandler, boolean canSave) {
        this.topicalityHandler = topicalityHandler;
        this.canSave = canSave;
    }

    protected final TopicalityHandler getTopicalityHandler() {
        return this.topicalityHandler;
    }

    public final boolean canSave() {
        return this.canSave;
    }

    public final void preloadModel() {
        this.getModel();
    }

    protected final Object getModel() {
        return this.getModel(true);
    }

    protected final Object getModel(boolean overwriteWhenChanged) {
        return this.getModel(this.model, overwriteWhenChanged);
    }

    public final boolean wasModelSourceChanged() {
        return this.getTopicalityHandler().hasChanged();
    }

    private Object getModel(Object currentModel, boolean overwriteWhenChanged) {
        this.model = currentModel;
        if (currentModel == null || overwriteWhenChanged && this.wasModelSourceChanged()) {
            try {
                this.model = this.loadModel();
                this.getTopicalityHandler().resetTopicality();
                this.notifyModelChange();
            }
            catch (IOException e) {
                this.getLogger().error("Error reading model data from source.", e);
            }
        }
        return this.model;
    }

    protected final void saveModel() {
        if (this.canSave()) {
            try {
                this.saveModel(this.model);
                this.getTopicalityHandler().resetTopicality();
                this.notifyModelChange();
            }
            catch (IOException e) {
                this.getLogger().error("Error writing model data to source.", e);
            }
        }
    }

    protected final void forceModelReload() {
        this.getTopicalityHandler().setChangedFlag();
        this.notifyModelChange();
    }

    protected void notifyModelChange() {
    }

    protected abstract Object loadModel() throws IOException;

    protected abstract void saveModel(Object var1) throws IOException;
}

