/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.listener;

import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.listener.JoinThreadBuilder;
import com.schneide.base.listener.NotificationJoinThread;
import com.schneide.base.listener.Notifier;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.threading.Executable;
import com.schneide.base.threading.SchneideThread;
import java.util.ArrayList;

public abstract class ListenerHandler<L>
extends LoggedObject {
    private final String denotation;

    public ListenerHandler(String denotation) {
        this.denotation = denotation;
    }

    public abstract void addListener(L var1);

    public abstract void removeListener(L var1);

    public void notifyListeners(Notifier<L> notifier) {
        this.notifyListeners(this.getIterableFrom(notifier));
    }

    public void notifyListeners(Iterable<Notifier<L>> notifications) {
        Iterable<L> currentListeners = this.getCurrentListeners();
        for (L listener : currentListeners) {
            this.notifyListener(listener, notifications);
        }
    }

    protected void notifyListener(L listener, Iterable<Notifier<L>> notifications) {
        try {
            for (Notifier<L> notifier : notifications) {
                notifier.performNotificationFor(listener);
            }
        }
        catch (Exception e) {
            this.handleException(listener, e);
        }
    }

    public void notifyListenersInNewThread(Notifier<L> notifier) {
        this.notifyListenersInNewThread(this.getIterableFrom(notifier));
    }

    public void notifyListenersInNewThread(Iterable<Notifier<L>> notifications) {
        SchneideThread.startWorker("notification thread for " + this.denotation, () -> this.notifyListeners(notifications));
    }

    protected Iterable<Notifier<L>> getIterableFrom(Notifier<L> notifier) {
        ArrayList<Notifier<L>> result = new ArrayList<Notifier<L>>();
        result.add(notifier);
        return result;
    }

    public void notifyListenersAsynchronously(Notifier<L> notifier) {
        this.notifyListenersAsynchronously(this.getIterableFrom(notifier));
    }

    public void notifyListenersAsynchronously(Iterable<Notifier<L>> notifications) {
        Iterable<L> currentListeners = this.getCurrentListeners();
        for (L listener : currentListeners) {
            SchneideThread.startWorker(this.getNotificationThreadDenotationFor(listener), () -> this.notifyListener(listener, notifications));
        }
    }

    protected String getNotificationThreadDenotationFor(L listener) {
        return "notification of " + this.denotation + "::" + String.valueOf(listener);
    }

    public void notifyListenersAsynchronouslyAndWaitForCompletion(Notifier<L> notifier, JoinThreadBuilder joinBuilder) {
        this.notifyListenersAsynchronouslyAndWaitForCompletion(this.getIterableFrom(notifier), joinBuilder);
    }

    public void notifyListenersAsynchronouslyAndWaitForCompletion(final Iterable<Notifier<L>> notifications, JoinThreadBuilder joinBuilder) {
        Iterable<L> currentListeners = this.getCurrentListeners();
        ArrayList<Executable> notificationThreads = new ArrayList<Executable>();
        for (final L listener : currentListeners) {
            notificationThreads.add(new Executable(this.getNotificationThreadDenotationFor(listener)){

                @Override
                protected void execute() throws Exception {
                    ListenerHandler.this.notifyListener(listener, notifications);
                }
            });
        }
        NotificationJoinThread endThread = joinBuilder.createJoinThreadFor(notificationThreads);
        endThread.startExecution();
    }

    protected void warnAboutNullParameters(String actionDenotation) {
        this.getLogger().warn("Attempted to " + actionDenotation + " a null reference as a listener.", new Throwable());
    }

    protected void handleException(L listener, Exception e) {
        this.getLogger().error("Error when notifying listener: " + String.valueOf(listener), e);
    }

    protected abstract Iterable<L> getCurrentListeners();

    public String toString() {
        return "ListenerHandler " + this.denotation + " with " + IterableUtil.getSizeFor(this.getCurrentListeners()) + " registered listeners.";
    }
}

