/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.layout.tablelayout;

import com.schneide.base.layout.tablelayout.TableLineSpecificationInterpreter;

public abstract class TableLine {
    private final double size;
    private final boolean isSpacer;

    public TableLine(String representation) {
        this(new TableLineSpecificationInterpreter(representation));
    }

    private TableLine(TableLineSpecificationInterpreter specification) {
        this(specification.getSize(), specification.isSpacer());
    }

    public TableLine(double size) {
        this(size, false);
    }

    public TableLine(double size, boolean isSpacer) {
        this.size = size;
        this.isSpacer = isSpacer;
    }

    public boolean isSpacer() {
        return this.isSpacer;
    }

    public double getSize() {
        return this.size;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getTypeDenotation());
        result.append(": ");
        result.append(this.getSize());
        if (this.isSpacer()) {
            result.append(" (spacer)");
        }
        return result.toString();
    }

    protected abstract String getTypeDenotation();
}

